/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.transformer;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.web.client.TestRestTemplate;
import org.springframework.boot.test.web.server.LocalServerPort;
import org.springframework.core.io.ClassPathResource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.test.util.AssertionErrors;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

@Deprecated
public abstract class AbstractHttpRequestTest {
    @LocalServerPort
    private int port;
    @Autowired
    private TestRestTemplate restTemplate;

    protected abstract String getTransformerName();

    protected abstract String getSourceExtension();

    @Test
    public void testPageExists() {
        String result = (String)this.restTemplate.getForObject("http://localhost:" + this.port + "/", String.class, new Object[0]);
        String title = this.getTransformerName() + " Test Transformation";
        AssertionErrors.assertTrue((String)("\"" + title + "\" should be part of the page title"), (boolean)result.contains(title));
    }

    @Test
    public void logPageExists() {
        String result = (String)this.restTemplate.getForObject("http://localhost:" + this.port + "/log", String.class, new Object[0]);
        String title = this.getTransformerName() + " Log";
        AssertionErrors.assertTrue((String)("\"" + title + "\" should be part of the page title"), (boolean)result.contains(title));
    }

    @Test
    public void errorPageExists() {
        String result = (String)this.restTemplate.getForObject("http://localhost:" + this.port + "/error", String.class, new Object[0]);
        String title = this.getTransformerName() + " Error Page";
        AssertionErrors.assertTrue((String)("\"" + title + "\" should be part of the page title"), (boolean)result.contains("Error Page"));
    }

    @Test
    public void noFileError() {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        parameters.add((Object)"targetExtension", (Object)".tmp");
        this.assertTransformError(false, this.getTransformerName() + " - Required request part 'file' is not present", (LinkedMultiValueMap<String, Object>)parameters);
    }

    @Test
    public void noTargetExtensionError() {
        this.assertMissingParameter("targetExtension");
    }

    private void assertMissingParameter(String name) {
        this.assertTransformError(true, this.getTransformerName() + " - Request parameter '" + name + "' is missing", null);
    }

    protected void assertTransformError(boolean addFile, String errorMessage, LinkedMultiValueMap<String, Object> additionalParams) {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        if (addFile) {
            parameters.add((Object)"file", (Object)new ClassPathResource("quick." + this.getSourceExtension()));
        }
        if (additionalParams != null) {
            parameters.addAll(additionalParams);
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.MULTIPART_FORM_DATA);
        HttpEntity entity = new HttpEntity((Object)parameters, (MultiValueMap)headers);
        this.sendTranformationRequest((HttpEntity<LinkedMultiValueMap<String, Object>>)entity, errorMessage);
    }

    @Test
    public void httpTransformRequestDirectAccessUrlNotFoundTest() {
        String directUrl = "https://expired/direct/access/url";
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        parameters.add((Object)"targetExtension", (Object)".tmp");
        parameters.add((Object)"directAccessUrl", (Object)directUrl);
        this.assertTransformError(false, this.getTransformerName() + " - Direct Access Url not found.", (LinkedMultiValueMap<String, Object>)parameters);
    }

    protected void sendTranformationRequest(HttpEntity<LinkedMultiValueMap<String, Object>> entity, String errorMessage) {
        ResponseEntity response = this.restTemplate.exchange("/transform", HttpMethod.POST, entity, String.class, new Object[]{""});
        Assertions.assertEquals((Object)errorMessage, (Object)this.getErrorMessage((String)response.getBody()));
    }

    private String getErrorMessage(String content) {
        int j;
        String message = "";
        int i = content.indexOf("\"message\":\"");
        if (i != -1 && (j = content.indexOf("\",\"path\":", i)) != -1) {
            message = content.substring(i + 11, j);
        }
        return message;
    }
}

