/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.transformer;

import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import java.util.Optional;
import org.alfresco.transform.client.model.TransformReply;
import org.alfresco.transform.client.model.TransformRequest;
import org.alfresco.transform.exceptions.TransformException;
import org.alfresco.transformer.TransformController;
import org.alfresco.transformer.messaging.TransformMessageConverter;
import org.alfresco.transformer.messaging.TransformReplySender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.http.HttpStatus;
import org.springframework.jms.annotation.JmsListener;
import org.springframework.jms.support.converter.MessageConversionException;
import org.springframework.stereotype.Component;

@Deprecated
@Component
@ConditionalOnProperty(name={"activemq.url"})
public class QueueTransformService {
    private static final Logger logger = LoggerFactory.getLogger(QueueTransformService.class);
    @Autowired
    private TransformController transformController;
    @Autowired
    private TransformMessageConverter transformMessageConverter;
    @Autowired
    private TransformReplySender transformReplySender;

    @JmsListener(destination="${queue.engineRequestQueue}", concurrency="${jms-listener.concurrency}")
    public void receive(Message msg) {
        Optional<TransformRequest> transformRequest;
        Destination replyToDestinationQueue;
        if (msg == null) {
            logger.error("Received null message!");
            return;
        }
        String correlationId = QueueTransformService.tryRetrieveCorrelationId(msg);
        try {
            replyToDestinationQueue = msg.getJMSReplyTo();
            if (replyToDestinationQueue == null) {
                logger.error("Cannot find 'replyTo' destination queue for message with correlationID {}. Stopping. ", (Object)correlationId);
                return;
            }
        }
        catch (JMSException e) {
            logger.error("Cannot find 'replyTo' destination queue for message with correlationID {}. Stopping. ", (Object)correlationId);
            return;
        }
        logger.trace("New T-Request from queue with correlationId: {}", (Object)correlationId);
        try {
            transformRequest = this.convert(msg, correlationId);
        }
        catch (TransformException e) {
            logger.error(e.getMessage(), (Throwable)e);
            this.replyWithError(replyToDestinationQueue, HttpStatus.valueOf((int)e.getStatusCode()), e.getMessage(), correlationId);
            return;
        }
        if (!transformRequest.isPresent()) {
            logger.error("T-Request from message with correlationID {} is null!", (Object)correlationId);
            this.replyWithInternalSvErr(replyToDestinationQueue, "JMS exception during T-Request deserialization: ", correlationId);
            return;
        }
        TransformReply reply = (TransformReply)this.transformController.transform(transformRequest.get(), null).getBody();
        this.transformReplySender.send(replyToDestinationQueue, reply);
    }

    private Optional<TransformRequest> convert(Message msg, String correlationId) {
        try {
            TransformRequest request = (TransformRequest)this.transformMessageConverter.fromMessage(msg);
            return Optional.ofNullable(request);
        }
        catch (MessageConversionException e) {
            String message = "MessageConversionException during T-Request deserialization of message with correlationID " + correlationId + ": ";
            throw new TransformException(HttpStatus.BAD_REQUEST, message + e.getMessage());
        }
        catch (JMSException e) {
            String message = "JMSException during T-Request deserialization of message with correlationID " + correlationId + ": ";
            throw new TransformException(HttpStatus.INTERNAL_SERVER_ERROR, message + e.getMessage());
        }
        catch (Exception e) {
            String message = "Exception during T-Request deserialization of message with correlationID " + correlationId + ": ";
            throw new TransformException(HttpStatus.INTERNAL_SERVER_ERROR, message + e.getMessage());
        }
    }

    private void replyWithInternalSvErr(Destination destination, String msg, String correlationId) {
        this.replyWithError(destination, HttpStatus.INTERNAL_SERVER_ERROR, msg, correlationId);
    }

    private void replyWithError(Destination destination, HttpStatus status, String msg, String correlationId) {
        TransformReply reply = TransformReply.builder().withStatus(status.value()).withErrorDetails(msg).build();
        this.transformReplySender.send(destination, reply, correlationId);
    }

    private static String tryRetrieveCorrelationId(Message msg) {
        try {
            return msg.getJMSCorrelationID();
        }
        catch (Exception ignore) {
            return null;
        }
    }
}

