/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.transformer;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.transform.client.model.InternalContext;
import org.alfresco.transform.client.model.TransformReply;
import org.alfresco.transform.client.model.TransformRequest;
import org.alfresco.transform.config.SupportedSourceAndTarget;
import org.alfresco.transform.config.TransformConfig;
import org.alfresco.transform.config.TransformOptionGroup;
import org.alfresco.transform.config.TransformOptionValue;
import org.alfresco.transform.config.Transformer;
import org.alfresco.transform.messages.TransformStack;
import org.alfresco.transform.registry.TransformServiceRegistry;
import org.alfresco.transformer.AbstractTransformerController;
import org.alfresco.transformer.clients.AlfrescoSharedFileStoreClient;
import org.alfresco.transformer.probes.ProbeTestTransform;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.test.mock.mockito.MockBean;
import org.springframework.boot.test.mock.mockito.SpyBean;
import org.springframework.core.io.ClassPathResource;
import org.springframework.http.HttpStatus;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.test.util.ReflectionTestUtils;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockHttpServletRequestBuilder;
import org.springframework.test.web.servlet.request.MockMultipartHttpServletRequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

@Deprecated
public abstract class AbstractTransformerControllerTest {
    @TempDir
    public File tempDir;
    @Autowired
    protected MockMvc mockMvc;
    @Autowired
    protected ObjectMapper objectMapper;
    @MockBean
    protected AlfrescoSharedFileStoreClient alfrescoSharedFileStoreClient;
    @SpyBean
    protected TransformServiceRegistry transformRegistry;
    @Value(value="${transform.core.version}")
    private String coreVersion;
    protected String sourceExtension;
    protected String targetExtension;
    protected String sourceMimetype;
    protected String targetMimetype;
    protected HashMap<String, String> options = new HashMap();
    protected MockMultipartFile sourceFile;
    protected String expectedOptions;
    protected String expectedSourceSuffix;
    protected Long expectedTimeout = 0L;
    protected byte[] expectedSourceFileBytes;
    protected byte[] expectedTargetFileBytes;

    protected abstract void mockTransformCommand(String var1, String var2, String var3, boolean var4) throws IOException;

    protected abstract AbstractTransformerController getController();

    protected abstract void updateTransformRequestWithSpecificOptions(TransformRequest var1);

    void generateTargetFileFromResourceFile(String actualTargetExtension, File testFile, File targetFile) throws IOException {
        block26: {
            if (testFile != null) {
                try (FileInputStream inputStream = new FileInputStream(testFile);
                     FileOutputStream outputStream = new FileOutputStream(targetFile);){
                    FileChannel source = inputStream.getChannel();
                    FileChannel target = outputStream.getChannel();
                    target.transferFrom(source, 0L, source.size());
                    break block26;
                }
            }
            testFile = this.getTestFile("quick." + actualTargetExtension, false);
            if (testFile != null) {
                try (FileInputStream inputStream = new FileInputStream(testFile);
                     FileOutputStream outputStream = new FileOutputStream(targetFile);){
                    FileChannel source = inputStream.getChannel();
                    FileChannel target = outputStream.getChannel();
                    target.transferFrom(source, 0L, source.size());
                }
            }
        }
    }

    protected byte[] readTestFile(String extension) throws IOException {
        return Files.readAllBytes(this.getTestFile("quick." + extension, true).toPath());
    }

    protected File getTestFile(String testFilename, boolean required) throws IOException {
        File testFile = null;
        ClassLoader classLoader = this.getClass().getClassLoader();
        URL testFileUrl = classLoader.getResource(testFilename);
        if (required && testFileUrl == null) {
            throw new IOException("The test file " + testFilename + " does not exist in the resources directory");
        }
        if (testFileUrl != null) {
            testFile = new File(this.tempDir, testFilename);
            Files.copy(classLoader.getResourceAsStream(testFilename), testFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        return testFileUrl == null ? null : testFile;
    }

    protected MockHttpServletRequestBuilder mockMvcRequest(String url, MockMultipartFile sourceFile, String ... params) {
        if (sourceFile == null) {
            return this.mockMvcRequestWithoutMockMultipartFile(url, params);
        }
        return this.mockMvcRequestWithMockMultipartFile(url, sourceFile, params);
    }

    private MockHttpServletRequestBuilder mockMvcRequestWithoutMockMultipartFile(String url, String ... params) {
        MockMultipartHttpServletRequestBuilder builder = MockMvcRequestBuilders.multipart((String)"/transform", (Object[])new Object[0]);
        if (params.length % 2 != 0) {
            throw new IllegalArgumentException("each param should have a name and value.");
        }
        for (int i = 0; i < params.length; i += 2) {
            builder = builder.param(params[i], new String[]{params[i + 1]});
        }
        return builder;
    }

    private MockHttpServletRequestBuilder mockMvcRequestWithMockMultipartFile(String url, MockMultipartFile sourceFile, String ... params) {
        MockMultipartHttpServletRequestBuilder builder = MockMvcRequestBuilders.multipart((String)"/transform", (Object[])new Object[0]).file(sourceFile);
        if (params.length % 2 != 0) {
            throw new IllegalArgumentException("each param should have a name and value.");
        }
        for (int i = 0; i < params.length; i += 2) {
            builder = builder.param(params[i], new String[]{params[i + 1]});
        }
        return builder;
    }

    protected TransformRequest createTransformRequest(String sourceFileRef, File sourceFile) {
        TransformRequest transformRequest = new TransformRequest();
        transformRequest.setRequestId("1");
        transformRequest.setSchema(1);
        transformRequest.setClientData("Alfresco Digital Business Platform");
        transformRequest.setTransformRequestOptions(this.options);
        transformRequest.setSourceReference(sourceFileRef);
        transformRequest.setSourceExtension(this.sourceExtension);
        transformRequest.setSourceMediaType(this.sourceMimetype);
        transformRequest.setSourceSize(Long.valueOf(sourceFile.length()));
        transformRequest.setTargetExtension(this.targetExtension);
        transformRequest.setTargetMediaType(this.targetMimetype);
        transformRequest.setInternalContext(InternalContext.initialise(null));
        transformRequest.getInternalContext().getMultiStep().setInitialRequestId("123");
        transformRequest.getInternalContext().getMultiStep().setInitialSourceMediaType(this.sourceMimetype);
        TransformStack.setInitialTransformRequestOptions((InternalContext)transformRequest.getInternalContext(), this.options);
        TransformStack.setInitialSourceReference((InternalContext)transformRequest.getInternalContext(), (String)sourceFileRef);
        TransformStack.addTransformLevel((InternalContext)transformRequest.getInternalContext(), (TransformStack.LevelBuilder)TransformStack.levelBuilder((String)"P").withStep("transformerName", this.sourceMimetype, this.targetMimetype));
        return transformRequest;
    }

    @Test
    public void simpleTransformTest() throws Exception {
        this.mockMvc.perform((RequestBuilder)this.mockMvcRequest("/transform", this.sourceFile, "targetExtension", this.targetExtension)).andExpect(MockMvcResultMatchers.status().is(HttpStatus.OK.value())).andExpect(MockMvcResultMatchers.content().bytes(this.expectedTargetFileBytes)).andExpect(MockMvcResultMatchers.header().string("Content-Disposition", "attachment; filename*= UTF-8''quick." + this.targetExtension));
    }

    @Test
    public void testDelayTest() throws Exception {
        long start = System.currentTimeMillis();
        this.mockMvc.perform((RequestBuilder)this.mockMvcRequest("/transform", this.sourceFile, "targetExtension", this.targetExtension, "testDelay", "400")).andExpect(MockMvcResultMatchers.status().is(HttpStatus.OK.value())).andExpect(MockMvcResultMatchers.content().bytes(this.expectedTargetFileBytes)).andExpect(MockMvcResultMatchers.header().string("Content-Disposition", "attachment; filename*= UTF-8''quick." + this.targetExtension));
        long ms = System.currentTimeMillis() - start;
        System.out.println("Transform incluing test delay was " + ms);
        Assertions.assertTrue((ms >= 400L ? 1 : 0) != 0, (String)("Delay sending the result back was too small " + ms));
        Assertions.assertTrue((ms <= 500L ? 1 : 0) != 0, (String)("Delay sending the result back was too big " + ms));
    }

    @Test
    public void noTargetFileTest() throws Exception {
        this.mockMvc.perform((RequestBuilder)this.mockMvcRequest("/transform", this.sourceFile, "targetExtension", "xxx")).andExpect(MockMvcResultMatchers.status().is(HttpStatus.INTERNAL_SERVER_ERROR.value()));
    }

    @Test
    public void dotDotSourceFilenameTest() throws Exception {
        this.sourceFile = new MockMultipartFile("file", "../quick." + this.sourceExtension, this.sourceMimetype, this.expectedSourceFileBytes);
        this.mockMvc.perform((RequestBuilder)this.mockMvcRequest("/transform", this.sourceFile, "targetExtension", this.targetExtension)).andExpect(MockMvcResultMatchers.status().is(HttpStatus.OK.value())).andExpect(MockMvcResultMatchers.content().bytes(this.expectedTargetFileBytes)).andExpect(MockMvcResultMatchers.header().string("Content-Disposition", "attachment; filename*= UTF-8''quick." + this.targetExtension));
    }

    @Test
    public void noExtensionSourceFilenameTest() throws Exception {
        this.sourceFile = new MockMultipartFile("file", "../quick", this.sourceMimetype, this.expectedSourceFileBytes);
        this.mockMvc.perform((RequestBuilder)this.mockMvcRequest("/transform", this.sourceFile, "targetExtension", this.targetExtension)).andExpect(MockMvcResultMatchers.status().is(HttpStatus.OK.value())).andExpect(MockMvcResultMatchers.content().bytes(this.expectedTargetFileBytes)).andExpect(MockMvcResultMatchers.header().string("Content-Disposition", "attachment; filename*= UTF-8''quick." + this.targetExtension));
    }

    @Test
    public void badSourceFilenameTest() throws Exception {
        this.sourceFile = new MockMultipartFile("file", "abc/", this.sourceMimetype, this.expectedSourceFileBytes);
        this.mockMvc.perform((RequestBuilder)this.mockMvcRequest("/transform", this.sourceFile, "targetExtension", this.targetExtension)).andExpect(MockMvcResultMatchers.status().is(HttpStatus.BAD_REQUEST.value())).andExpect(MockMvcResultMatchers.status().reason(Matchers.containsString((String)"The source filename was not supplied")));
    }

    @Test
    public void blankSourceFilenameTest() throws Exception {
        this.sourceFile = new MockMultipartFile("file", "", this.sourceMimetype, this.expectedSourceFileBytes);
        this.mockMvc.perform((RequestBuilder)this.mockMvcRequest("/transform", this.sourceFile, "targetExtension", this.targetExtension)).andExpect(MockMvcResultMatchers.status().is(HttpStatus.BAD_REQUEST.value()));
    }

    @Test
    public void noTargetExtensionTest() throws Exception {
        this.mockMvc.perform((RequestBuilder)this.mockMvcRequest("/transform", this.sourceFile, new String[0])).andExpect(MockMvcResultMatchers.status().is(HttpStatus.BAD_REQUEST.value())).andExpect(MockMvcResultMatchers.status().reason(Matchers.containsString((String)"Request parameter 'targetExtension' is missing")));
    }

    @Test
    public void calculateMaxTime() throws Exception {
        long[][] values;
        ProbeTestTransform probeTestTransform = this.getController().getProbeTestTransform();
        probeTestTransform.setLivenessPercent(110);
        for (long[] v : values = new long[][]{{5000L, 0L, Long.MAX_VALUE}, {1000L, 1000L, 2100L}, {3000L, 2000L, 4200L}, {2000L, 2000L, 4200L}, {6000L, 3000L, 6300L}, {8000L, 4000L, 8400L}, {4444L, 4000L, 8400L}, {5555L, 4000L, 8400L}}) {
            long time = v[0];
            long expectedNormalTime = v[1];
            long expectedMaxTime = v[2];
            probeTestTransform.calculateMaxTime(time, true);
            Assertions.assertEquals((long)expectedNormalTime, (long)probeTestTransform.getNormalTime());
            Assertions.assertEquals((long)expectedMaxTime, (long)probeTestTransform.getMaxTime());
        }
    }

    @Test
    public void testEmptyPojoTransform() throws Exception {
        TransformRequest transformRequest = new TransformRequest();
        String tr = this.objectMapper.writeValueAsString((Object)transformRequest);
        String transformationReplyAsString = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/transform", (Object[])new Object[0]).header("Accept", new Object[]{"application/json"}).header("Content-Type", new Object[]{"application/json"}).content(tr)).andExpect(MockMvcResultMatchers.status().is(HttpStatus.BAD_REQUEST.value())).andReturn().getResponse().getContentAsString();
        TransformReply transformReply = (TransformReply)this.objectMapper.readValue(transformationReplyAsString, TransformReply.class);
        Assertions.assertEquals((int)HttpStatus.BAD_REQUEST.value(), (int)transformReply.getStatus());
    }

    public String getEngineConfigName() {
        return "engine_config.json";
    }

    @Test
    public void testGetTransformConfigInfo() throws Exception {
        TransformConfig expectedTransformConfig = (TransformConfig)this.objectMapper.readValue(this.getTestFile(this.getEngineConfigName(), true), TransformConfig.class);
        expectedTransformConfig.getTransformers().forEach(transformer -> {
            transformer.setCoreVersion(this.coreVersion);
            transformer.getTransformOptions().add("directAccessUrl");
        });
        expectedTransformConfig.getTransformOptions().put("directAccessUrl", Set.of(new TransformOptionValue(false, "directAccessUrl")));
        ReflectionTestUtils.setField((Object)this.transformRegistry, (String)"engineConfig", (Object)new ClassPathResource(this.getEngineConfigName()));
        String response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/transform/config?configVersion=2", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().is(HttpStatus.OK.value())).andExpect(MockMvcResultMatchers.header().string("Content-Type", "application/json")).andReturn().getResponse().getContentAsString();
        TransformConfig transformConfig = (TransformConfig)this.objectMapper.readValue(response, TransformConfig.class);
        Assertions.assertEquals((Object)expectedTransformConfig, (Object)transformConfig);
    }

    @Test
    public void testGetTransformConfigInfoExcludingCoreVersion() throws Exception {
        TransformConfig expectedTransformConfig = (TransformConfig)this.objectMapper.readValue(this.getTestFile(this.getEngineConfigName(), true), TransformConfig.class);
        ReflectionTestUtils.setField((Object)this.transformRegistry, (String)"engineConfig", (Object)new ClassPathResource(this.getEngineConfigName()));
        String response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/transform/config", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().is(HttpStatus.OK.value())).andExpect(MockMvcResultMatchers.header().string("Content-Type", "application/json")).andReturn().getResponse().getContentAsString();
        TransformConfig transformConfig = (TransformConfig)this.objectMapper.readValue(response, TransformConfig.class);
        Assertions.assertEquals((Object)expectedTransformConfig, (Object)transformConfig);
    }

    @Test
    public void testGetInfoFromConfigWithDuplicates() throws Exception {
        TransformConfig expectedResult = this.buildCompleteTransformConfig();
        ReflectionTestUtils.setField((Object)this.transformRegistry, (String)"engineConfig", (Object)new ClassPathResource("engine_config_with_duplicates.json"));
        String response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/transform/config", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().is(HttpStatus.OK.value())).andExpect(MockMvcResultMatchers.header().string("Content-Type", "application/json")).andReturn().getResponse().getContentAsString();
        TransformConfig transformConfig = (TransformConfig)this.objectMapper.readValue(response, TransformConfig.class);
        Assertions.assertNotNull((Object)transformConfig);
        Assertions.assertEquals((Object)expectedResult, (Object)transformConfig);
        Assertions.assertEquals((int)3, (int)((Set)transformConfig.getTransformOptions().get("engineXOptions")).size());
        Assertions.assertEquals((int)1, (int)((Transformer)transformConfig.getTransformers().get(0)).getSupportedSourceAndTargetList().size());
        Assertions.assertEquals((int)1, (int)((Transformer)transformConfig.getTransformers().get(0)).getTransformOptions().size());
    }

    @Test
    public void testGetInfoFromConfigWithEmptyTransformOptions() throws Exception {
        Transformer transformer = this.buildTransformer("application/pdf", "image/png");
        TransformConfig expectedResult = new TransformConfig();
        expectedResult.setTransformers((List)ImmutableList.of((Object)transformer));
        ReflectionTestUtils.setField((Object)this.transformRegistry, (String)"engineConfig", (Object)new ClassPathResource("engine_config_incomplete.json"));
        String response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/transform/config", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().is(HttpStatus.OK.value())).andExpect(MockMvcResultMatchers.header().string("Content-Type", "application/json")).andReturn().getResponse().getContentAsString();
        TransformConfig transformConfig = (TransformConfig)this.objectMapper.readValue(response, TransformConfig.class);
        Assertions.assertNotNull((Object)transformConfig);
        Assertions.assertEquals((Object)expectedResult, (Object)transformConfig);
    }

    @Test
    public void testGetInfoFromConfigWithNoTransformOptions() throws Exception {
        Transformer transformer = this.buildTransformer("application/pdf", "image/png");
        transformer.setTransformerName("engineX");
        TransformConfig expectedResult = new TransformConfig();
        expectedResult.setTransformers((List)ImmutableList.of((Object)transformer));
        ReflectionTestUtils.setField((Object)this.transformRegistry, (String)"engineConfig", (Object)new ClassPathResource("engine_config_no_transform_options.json"));
        String response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/transform/config", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().is(HttpStatus.OK.value())).andExpect(MockMvcResultMatchers.header().string("Content-Type", "application/json")).andReturn().getResponse().getContentAsString();
        TransformConfig transformConfig = (TransformConfig)this.objectMapper.readValue(response, TransformConfig.class);
        Assertions.assertNotNull((Object)transformConfig);
        Assertions.assertEquals((Object)expectedResult, (Object)transformConfig);
    }

    private TransformConfig buildCompleteTransformConfig() {
        TransformConfig expectedResult = new TransformConfig();
        ImmutableSet transformOptionGroup = ImmutableSet.of((Object)new TransformOptionValue(false, "cropGravity"));
        ImmutableSet transformOptions = ImmutableSet.of((Object)new TransformOptionValue(false, "page"), (Object)new TransformOptionValue(false, "width"), (Object)new TransformOptionGroup(false, (Set)transformOptionGroup));
        ImmutableMap transformOptionsMap = ImmutableMap.of((Object)"engineXOptions", (Object)transformOptions);
        Transformer transformer = this.buildTransformer("application/pdf", "image/png", "engineXOptions", "engineX");
        ImmutableList transformers = ImmutableList.of((Object)transformer);
        expectedResult.setTransformOptions((Map)transformOptionsMap);
        expectedResult.setTransformers((List)transformers);
        return expectedResult;
    }

    private Transformer buildTransformer(String sourceMediaType, String targetMediaType, String transformOptions, String transformerName) {
        Transformer transformer = this.buildTransformer(sourceMediaType, targetMediaType);
        transformer.setTransformerName(transformerName);
        transformer.setTransformOptions((Set)ImmutableSet.of((Object)transformOptions));
        return transformer;
    }

    private Transformer buildTransformer(String sourceMediaType, String targetMediaType) {
        ImmutableSet supportedSourceAndTargetList = ImmutableSet.of((Object)((SupportedSourceAndTarget)((SupportedSourceAndTarget.Builder)((SupportedSourceAndTarget.Builder)SupportedSourceAndTarget.builder().withSourceMediaType(sourceMediaType)).withTargetMediaType(targetMediaType)).build()));
        Transformer transformer = new Transformer();
        transformer.setSupportedSourceAndTargetList((Set)supportedSourceAndTargetList);
        return transformer;
    }
}

