/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.transformer.probes;

import jakarta.servlet.http.HttpServletRequest;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.alfresco.transform.exceptions.TransformException;
import org.alfresco.transformer.AbstractTransformerController;
import org.alfresco.transformer.fs.FileManager;
import org.alfresco.transformer.logging.LogEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;

@Deprecated
public abstract class ProbeTestTransform {
    private final Logger logger = LoggerFactory.getLogger(ProbeTestTransform.class);
    private static final int AVERAGE_OVER_TRANSFORMS = 5;
    private final String sourceFilename;
    private final String targetFilename;
    private final long minExpectedLength;
    private final long maxExpectedLength;
    private int livenessPercent;
    private long probeCount;
    private int transCount;
    private long normalTime;
    private long maxTime = Long.MAX_VALUE;
    private long nextTransformTime;
    private final boolean livenessTransformEnabled;
    private final long livenessTransformPeriod;
    private final long maxTransformCount;
    private long maxTransformTime;
    private final AtomicBoolean initialised = new AtomicBoolean(false);
    private final AtomicBoolean readySent = new AtomicBoolean(false);
    private final AtomicLong transformCount = new AtomicLong(0L);
    private final AtomicBoolean die = new AtomicBoolean(false);

    public int getLivenessPercent() {
        return this.livenessPercent;
    }

    public long getMaxTime() {
        return this.maxTime;
    }

    public ProbeTestTransform(AbstractTransformerController controller, String sourceFilename, String targetFilename, long expectedLength, long plusOrMinus, int livenessPercent, long maxTransforms, long maxTransformSeconds, long livenessTransformPeriodSeconds) {
        this.sourceFilename = sourceFilename;
        this.targetFilename = targetFilename;
        this.minExpectedLength = Math.max(0L, expectedLength - plusOrMinus);
        this.maxExpectedLength = expectedLength + plusOrMinus;
        this.livenessPercent = (int)this.getPositiveLongEnv("livenessPercent", livenessPercent);
        this.maxTransformCount = this.getPositiveLongEnv("maxTransforms", maxTransforms);
        this.maxTransformTime = this.getPositiveLongEnv("maxTransformSeconds", maxTransformSeconds) * 1000L;
        this.livenessTransformPeriod = this.getPositiveLongEnv("livenessTransformPeriodSeconds", livenessTransformPeriodSeconds) * 1000L;
        this.livenessTransformEnabled = this.getBooleanEnvVar("livenessTransformEnabled", false);
    }

    private boolean getBooleanEnvVar(String name, boolean defaultValue) {
        try {
            return Boolean.parseBoolean(System.getenv(name));
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }

    private long getPositiveLongEnv(String name, long defaultValue) {
        long l = -1L;
        String env = System.getenv(name);
        if (env != null) {
            try {
                l = Long.parseLong(env);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (l <= 0L) {
            l = defaultValue;
        }
        this.logger.trace("Probe: {}={}", (Object)name, (Object)l);
        return l;
    }

    public String doTransformOrNothing(HttpServletRequest request, boolean isLiveProbe) {
        ++this.probeCount;
        if (isLiveProbe && !this.livenessTransformEnabled) {
            return this.doNothing(true);
        }
        return isLiveProbe && this.livenessTransformPeriod > 0L && (this.transCount <= 5 || this.nextTransformTime < System.currentTimeMillis()) || !this.initialised.get() ? this.doTransform(request, isLiveProbe) : this.doNothing(isLiveProbe);
    }

    private String doNothing(boolean isLiveProbe) {
        String probeMessage = this.getProbeMessage(isLiveProbe);
        String message = "Success - No transform.";
        LogEntry.setStatusCodeAndMessage(HttpStatus.OK.value(), probeMessage + message);
        if (!isLiveProbe && !this.readySent.getAndSet(true)) {
            this.logger.trace("{}{}", (Object)probeMessage, (Object)message);
        }
        return message;
    }

    private String doTransform(HttpServletRequest request, boolean isLiveProbe) {
        this.checkMaxTransformTimeAndCount(isLiveProbe);
        long start = System.currentTimeMillis();
        if (this.nextTransformTime != 0L) {
            do {
                this.nextTransformTime += this.livenessTransformPeriod;
            } while (this.nextTransformTime < start);
        }
        File sourceFile = this.getSourceFile(request, isLiveProbe);
        File targetFile = this.getTargetFile(request);
        this.executeTransformCommand(sourceFile, targetFile);
        long time = System.currentTimeMillis() - start;
        String message = "Transform " + time + "ms";
        this.checkTargetFile(targetFile, isLiveProbe, message);
        this.recordTransformTime(time);
        this.calculateMaxTime(time, isLiveProbe);
        if (time > this.maxTime) {
            throw new TransformException(HttpStatus.INTERNAL_SERVER_ERROR, this.getMessagePrefix(isLiveProbe) + message + " which is more than " + this.livenessPercent + "% slower than the normal value of " + this.normalTime + "ms");
        }
        this.initialised.set(true);
        this.checkMaxTransformTimeAndCount(isLiveProbe);
        return this.getProbeMessage(isLiveProbe) + message;
    }

    private void checkMaxTransformTimeAndCount(boolean isLiveProbe) {
        if (this.die.get()) {
            throw new TransformException(HttpStatus.TOO_MANY_REQUESTS, this.getMessagePrefix(isLiveProbe) + "Transformer requested to die. A transform took longer than " + this.maxTransformTime / 1000L + " seconds");
        }
        if (this.maxTransformCount > 0L && this.transformCount.get() > this.maxTransformCount) {
            throw new TransformException(HttpStatus.TOO_MANY_REQUESTS, this.getMessagePrefix(isLiveProbe) + "Transformer requested to die. It has performed more than " + this.maxTransformCount + " transformations");
        }
    }

    private File getSourceFile(HttpServletRequest request, boolean isLiveProbe) {
        this.incrementTransformerCount();
        File sourceFile = FileManager.TempFileProvider.createTempFile("source_", "_" + this.sourceFilename);
        request.setAttribute("sourceFile", (Object)sourceFile);
        try (InputStream inputStream = this.getClass().getResourceAsStream("/" + this.sourceFilename);){
            Files.copy(inputStream, sourceFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new TransformException(HttpStatus.INSUFFICIENT_STORAGE, this.getMessagePrefix(isLiveProbe) + "Failed to store the source file", (Throwable)e);
        }
        long length = sourceFile.length();
        LogEntry.setSource(this.sourceFilename, length);
        return sourceFile;
    }

    private File getTargetFile(HttpServletRequest request) {
        File targetFile = FileManager.TempFileProvider.createTempFile("target_", "_" + this.targetFilename);
        request.setAttribute("targetFile", (Object)targetFile);
        LogEntry.setTarget(this.targetFilename);
        return targetFile;
    }

    public void recordTransformTime(long time) {
        if (this.maxTransformTime > 0L && time > this.maxTransformTime) {
            this.die.set(true);
        }
    }

    public void calculateMaxTime(long time, boolean isLiveProbe) {
        if (this.transCount <= 5) {
            String message = this.getMessagePrefix(isLiveProbe) + "Success - Transform " + time + "ms";
            if (++this.transCount > 1) {
                this.normalTime = (this.normalTime * (long)(this.transCount - 2) + time) / (long)(this.transCount - 1);
                this.maxTime = this.normalTime * (long)(this.livenessPercent + 100) / 100L;
                if (!isLiveProbe && !this.readySent.getAndSet(true) || this.transCount > 5) {
                    this.nextTransformTime = System.currentTimeMillis() + this.livenessTransformPeriod;
                    this.logger.trace("{} - {}ms+{}%={}ms", new Object[]{message, this.normalTime, this.livenessPercent, this.maxTime});
                }
            } else if (!isLiveProbe && !this.readySent.getAndSet(true)) {
                this.logger.trace(message);
            }
        }
    }

    protected abstract void executeTransformCommand(File var1, File var2);

    private void checkTargetFile(File targetFile, boolean isLiveProbe, String message) {
        String probeMessage = this.getProbeMessage(isLiveProbe);
        if (!targetFile.exists() || !targetFile.isFile()) {
            throw new TransformException(HttpStatus.INTERNAL_SERVER_ERROR, probeMessage + "Target File \"" + targetFile.getAbsolutePath() + "\" did not exist");
        }
        long length = targetFile.length();
        if (length < this.minExpectedLength || length > this.maxExpectedLength) {
            throw new TransformException(HttpStatus.INTERNAL_SERVER_ERROR, probeMessage + "Target File \"" + targetFile.getAbsolutePath() + "\" was the wrong size (" + length + "). Needed to be between " + this.minExpectedLength + " and " + this.maxExpectedLength);
        }
        LogEntry.setTargetSize(length);
        LogEntry.setStatusCodeAndMessage(HttpStatus.OK.value(), probeMessage + "Success - " + message);
    }

    private String getMessagePrefix(boolean isLiveProbe) {
        return Long.toString(this.probeCount) + " " + this.getProbeMessage(isLiveProbe);
    }

    private String getProbeMessage(boolean isLiveProbe) {
        return isLiveProbe ? "Live Probe: " : "Ready Probe: ";
    }

    public void incrementTransformerCount() {
        this.transformCount.incrementAndGet();
    }

    public void setLivenessPercent(int livenessPercent) {
        this.livenessPercent = livenessPercent;
    }

    public long getNormalTime() {
        return this.normalTime;
    }
}

