/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.transformer;

import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import org.alfresco.transform.client.model.TransformReply;
import org.alfresco.transform.client.model.TransformRequest;
import org.alfresco.transformer.QueueTransformService;
import org.alfresco.transformer.TransformController;
import org.alfresco.transformer.messaging.TransformMessageConverter;
import org.alfresco.transformer.messaging.TransformReplySender;
import org.apache.activemq.command.ActiveMQObjectMessage;
import org.apache.activemq.command.ActiveMQQueue;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.jms.support.converter.MessageConversionException;

@Deprecated
public class QueueTransformServiceTest {
    @Mock
    private TransformController transformController;
    @Mock
    private TransformMessageConverter transformMessageConverter;
    @Mock
    private TransformReplySender transformReplySender;
    @InjectMocks
    private QueueTransformService queueTransformService;

    @BeforeEach
    public void setup() {
        MockitoAnnotations.initMocks((Object)this);
    }

    @Test
    public void testWhenReceiveNullMessageThenStopFlow() {
        this.queueTransformService.receive(null);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.transformController});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.transformMessageConverter});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.transformReplySender});
    }

    @Test
    public void testWhenReceiveMessageWithNoReplyToQueueThenStopFlow() {
        this.queueTransformService.receive((Message)new ActiveMQObjectMessage());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.transformController});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.transformMessageConverter});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.transformReplySender});
    }

    @Test
    public void testConvertMessageReturnsNullThenReplyWithInternalServerError() throws JMSException {
        ActiveMQObjectMessage msg = new ActiveMQObjectMessage();
        msg.setCorrelationId("1234");
        ActiveMQQueue destination = new ActiveMQQueue();
        msg.setJMSReplyTo((Destination)destination);
        TransformReply reply = TransformReply.builder().withStatus(HttpStatus.INTERNAL_SERVER_ERROR.value()).withErrorDetails("JMS exception during T-Request deserialization of message with correlationID " + msg.getCorrelationId() + ": null").build();
        ((TransformMessageConverter)Mockito.doReturn(null).when((Object)this.transformMessageConverter)).fromMessage((Message)msg);
        this.queueTransformService.receive((Message)msg);
        ((TransformMessageConverter)Mockito.verify((Object)this.transformMessageConverter)).fromMessage((Message)msg);
        ((TransformReplySender)Mockito.verify((Object)this.transformReplySender)).send((Destination)destination, reply, msg.getCorrelationId());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.transformController});
    }

    @Test
    public void testConvertMessageThrowsMessageConversionExceptionThenReplyWithBadRequest() throws JMSException {
        ActiveMQObjectMessage msg = new ActiveMQObjectMessage();
        msg.setCorrelationId("1234");
        ActiveMQQueue destination = new ActiveMQQueue();
        msg.setJMSReplyTo((Destination)destination);
        TransformReply reply = TransformReply.builder().withStatus(HttpStatus.BAD_REQUEST.value()).withErrorDetails("Message conversion exception during T-Request deserialization of message with correlationID" + msg.getCorrelationId() + ": null").build();
        ((TransformMessageConverter)Mockito.doThrow(MessageConversionException.class).when((Object)this.transformMessageConverter)).fromMessage((Message)msg);
        this.queueTransformService.receive((Message)msg);
        ((TransformMessageConverter)Mockito.verify((Object)this.transformMessageConverter)).fromMessage((Message)msg);
        ((TransformReplySender)Mockito.verify((Object)this.transformReplySender)).send((Destination)destination, reply, msg.getCorrelationId());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.transformController});
    }

    @Test
    public void testConvertMessageThrowsJMSExceptionThenReplyWithInternalServerError() throws JMSException {
        ActiveMQObjectMessage msg = new ActiveMQObjectMessage();
        msg.setCorrelationId("1234");
        ActiveMQQueue destination = new ActiveMQQueue();
        msg.setJMSReplyTo((Destination)destination);
        TransformReply reply = TransformReply.builder().withStatus(HttpStatus.INTERNAL_SERVER_ERROR.value()).withErrorDetails("JMSException during T-Request deserialization of message with correlationID " + msg.getCorrelationId() + ": null").build();
        ((TransformMessageConverter)Mockito.doThrow(JMSException.class).when((Object)this.transformMessageConverter)).fromMessage((Message)msg);
        this.queueTransformService.receive((Message)msg);
        ((TransformMessageConverter)Mockito.verify((Object)this.transformMessageConverter)).fromMessage((Message)msg);
        ((TransformReplySender)Mockito.verify((Object)this.transformReplySender)).send((Destination)destination, reply, msg.getCorrelationId());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.transformController});
    }

    @Test
    public void testWhenReceiveValidTransformRequestThenReplyWithSuccess() throws JMSException {
        ActiveMQObjectMessage msg = new ActiveMQObjectMessage();
        ActiveMQQueue destination = new ActiveMQQueue();
        msg.setJMSReplyTo((Destination)destination);
        TransformRequest request = new TransformRequest();
        TransformReply reply = TransformReply.builder().withStatus(HttpStatus.CREATED.value()).build();
        ((TransformMessageConverter)Mockito.doReturn((Object)request).when((Object)this.transformMessageConverter)).fromMessage((Message)msg);
        ((TransformController)Mockito.doReturn((Object)new ResponseEntity((Object)reply, (HttpStatusCode)HttpStatus.valueOf((int)reply.getStatus()))).when((Object)this.transformController)).transform(request, null);
        this.queueTransformService.receive((Message)msg);
        ((TransformMessageConverter)Mockito.verify((Object)this.transformMessageConverter)).fromMessage((Message)msg);
        ((TransformController)Mockito.verify((Object)this.transformController)).transform(request, null);
        ((TransformReplySender)Mockito.verify((Object)this.transformReplySender)).send((Destination)destination, reply);
    }

    @Test
    public void testWhenJMSExceptionOnMessageIsThrownThenStopFlow() throws JMSException {
        Message msg = (Message)Mockito.mock(Message.class);
        ((Message)Mockito.doThrow(JMSException.class).when((Object)msg)).getJMSReplyTo();
        this.queueTransformService.receive(msg);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.transformController});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.transformMessageConverter});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.transformReplySender});
    }

    @Test
    public void testWhenExceptionOnCorrelationIdIsThrownThenContinueFlowWithNullCorrelationId() throws JMSException {
        Message msg = (Message)Mockito.mock(Message.class);
        Destination destination = (Destination)Mockito.mock(Destination.class);
        ((Message)Mockito.doThrow(JMSException.class).when((Object)msg)).getJMSCorrelationID();
        ((Message)Mockito.doReturn((Object)destination).when((Object)msg)).getJMSReplyTo();
        TransformRequest request = new TransformRequest();
        TransformReply reply = TransformReply.builder().withStatus(HttpStatus.CREATED.value()).build();
        ((TransformMessageConverter)Mockito.doReturn((Object)request).when((Object)this.transformMessageConverter)).fromMessage(msg);
        ((TransformController)Mockito.doReturn((Object)new ResponseEntity((Object)reply, (HttpStatusCode)HttpStatus.valueOf((int)reply.getStatus()))).when((Object)this.transformController)).transform(request, null);
        this.queueTransformService.receive(msg);
        ((TransformMessageConverter)Mockito.verify((Object)this.transformMessageConverter)).fromMessage(msg);
        ((TransformController)Mockito.verify((Object)this.transformController)).transform(request, null);
        ((TransformReplySender)Mockito.verify((Object)this.transformReplySender)).send(destination, reply);
    }
}

