/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.transformer.executors;

import java.io.File;
import java.util.Map;
import org.alfresco.transform.exceptions.TransformException;
import org.springframework.http.HttpStatus;

@Deprecated
public interface Transformer {
    public String getTransformerId();

    default public void transform(String sourceMimetype, String targetMimetype, Map<String, String> transformOptions, File sourceFile, File targetFile) throws TransformException {
        String transformName = transformOptions.remove("alfresco.transform-name-parameter");
        this.transformExtractOrEmbed(transformName, sourceMimetype, targetMimetype, transformOptions, sourceFile, targetFile);
    }

    default public void transformExtractOrEmbed(String transformName, String sourceMimetype, String targetMimetype, Map<String, String> transformOptions, File sourceFile, File targetFile) throws TransformException {
        try {
            if ("alfresco-metadata-extract".equals(targetMimetype)) {
                this.extractMetadata(transformName, sourceMimetype, targetMimetype, transformOptions, sourceFile, targetFile);
            } else if ("alfresco-metadata-embed".equals(targetMimetype)) {
                this.embedMetadata(transformName, sourceMimetype, targetMimetype, transformOptions, sourceFile, targetFile);
            } else {
                this.transform(transformName, sourceMimetype, targetMimetype, transformOptions, sourceFile, targetFile);
            }
        }
        catch (TransformException e) {
            throw e;
        }
        catch (IllegalArgumentException e) {
            throw new TransformException(HttpStatus.BAD_REQUEST, Transformer.getMessage(e), (Throwable)e);
        }
        catch (Exception e) {
            throw new TransformException(HttpStatus.INTERNAL_SERVER_ERROR, Transformer.getMessage(e), (Throwable)e);
        }
        if (!targetFile.exists()) {
            throw new TransformException(HttpStatus.INTERNAL_SERVER_ERROR, "Transformer failed to create an output file. Target file does not exist.");
        }
        if (sourceFile.length() > 0L && targetFile.length() == 0L) {
            throw new TransformException(HttpStatus.INTERNAL_SERVER_ERROR, "Transformer failed to create an output file. Target file is empty but source file was not empty.");
        }
    }

    private static String getMessage(Exception e) {
        return e.getMessage() == null ? e.getClass().getSimpleName() : e.getMessage();
    }

    default public void transform(String transformName, String sourceMimetype, String targetMimetype, Map<String, String> transformOptions, File sourceFile, File targetFile) throws Exception {
    }

    default public void extractMetadata(String transformName, String sourceMimetype, String targetMimetype, Map<String, String> transformOptions, File sourceFile, File targetFile) throws Exception {
    }

    default public void embedMetadata(String transformName, String sourceMimetype, String targetMimetype, Map<String, String> transformOptions, File sourceFile, File targetFile) throws Exception {
    }
}

