/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.wcm.client.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.alfresco.wcm.client.impl.WebScriptCaller;
import org.alfresco.wcm.client.impl.WebscriptParam;
import org.alfresco.wcm.client.impl.WebscriptResponseHandler;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class WebScriptCallerImpl
implements WebScriptCaller {
    static Log log = LogFactory.getLog(WebScriptCallerImpl.class);
    private static ThreadLocal<byte[]> localBuffer = new ThreadLocal<byte[]>(){

        @Override
        protected byte[] initialValue() {
            return new byte[1024];
        }
    };
    private String baseUrl;
    HttpClient httpClient;
    private AuthScope authScope = new AuthScope(AuthScope.ANY_HOST, -1, AuthScope.ANY_REALM);
    private String username = null;
    private String password = null;

    public WebScriptCallerImpl() {
        this.httpClient = new HttpClient();
        this.httpClient.setHttpConnectionManager((HttpConnectionManager)new MultiThreadedHttpConnectionManager());
    }

    public void setHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public void setBaseUrl(String serviceLocation) throws URISyntaxException {
        this.baseUrl = serviceLocation;
        if (!this.baseUrl.endsWith("/")) {
            this.baseUrl = this.baseUrl + "/";
        }
    }

    public void setAuthScope(AuthScope authScope) {
        this.authScope = authScope;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void init() {
    }

    @Override
    public String getTicket(String user, String password) {
        TicketResponseHandler responseHandler = new TicketResponseHandler();
        ArrayList<WebscriptParam> paramList = new ArrayList<WebscriptParam>();
        paramList.add(new WebscriptParam("u", user));
        paramList.add(new WebscriptParam("pw", password));
        this.get("login", (WebscriptResponseHandler)responseHandler, paramList, true);
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(user, password);
        if (responseHandler.ticket != null) {
            credentials = new UsernamePasswordCredentials("", responseHandler.ticket);
        }
        this.httpClient.getState().setCredentials(this.authScope, (Credentials)credentials);
        this.httpClient.getParams().setAuthenticationPreemptive(true);
        return responseHandler.ticket;
    }

    @Override
    public JSONObject getJsonObject(String servicePath, List<WebscriptParam> params) {
        GetMethod getMethod = this.getGETMethod(servicePath, params);
        JsonResponseHandler handler = new JsonResponseHandler();
        this.executeRequest(handler, (HttpMethod)getMethod);
        return handler.jsonObject;
    }

    @Override
    public void get(String servicePath, WebscriptResponseHandler handler, List<WebscriptParam> params) {
        this.get(servicePath, handler, params, false);
    }

    private void get(String servicePath, WebscriptResponseHandler handler, List<WebscriptParam> params, boolean ignoreUnauthorized) {
        GetMethod getMethod = this.getGETMethod(servicePath, params);
        this.executeRequest(handler, (HttpMethod)getMethod, ignoreUnauthorized);
    }

    @Override
    public void post(String servicePath, WebscriptResponseHandler handler, List<WebscriptParam> params) {
        PostMethod postMethod = this.getPOSTMethod(servicePath, params);
        this.executeRequest(handler, (HttpMethod)postMethod);
    }

    private void executeRequest(WebscriptResponseHandler handler, HttpMethod httpMethod) {
        this.executeRequest(handler, httpMethod, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeRequest(WebscriptResponseHandler handler, HttpMethod httpMethod, boolean ignoreUnauthorized) {
        long startTime = 0L;
        if (log.isDebugEnabled()) {
            startTime = System.currentTimeMillis();
        }
        try {
            this.httpClient.executeMethod(httpMethod);
            if (!(httpMethod.getStatusCode() != 401 && httpMethod.getStatusCode() != 403 || ignoreUnauthorized)) {
                this.discardResponse(httpMethod);
                this.getTicket(this.username, this.password);
                this.httpClient.executeMethod(httpMethod);
            }
            if (httpMethod.getStatusCode() == 200) {
                handler.handleResponse(httpMethod.getResponseBodyAsStream());
            } else {
                this.discardResponse(httpMethod);
            }
        }
        catch (RuntimeException ex) {
            log.error((Object)"Rethrowing runtime exception.", (Throwable)ex);
            throw ex;
        }
        catch (Exception ex) {
            log.error((Object)"Failed to make request to Alfresco web script", (Throwable)ex);
        }
        finally {
            if (log.isDebugEnabled()) {
                log.debug((Object)(httpMethod.getName() + " request to " + httpMethod.getPath() + "?" + httpMethod.getQueryString() + " completed in " + (System.currentTimeMillis() - startTime) + "ms"));
            }
            httpMethod.releaseConnection();
        }
    }

    void discardResponse(HttpMethod httpMethod) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Received non-OK response when invoking method on path " + httpMethod.getPath() + ". Response was:\n" + httpMethod.getResponseBodyAsString()));
        } else {
            byte[] buf = localBuffer.get();
            InputStream responseStream = httpMethod.getResponseBodyAsStream();
            while (responseStream.read(buf) != -1) {
            }
        }
    }

    GetMethod getGETMethod(String servicePath, List<WebscriptParam> params) {
        GetMethod getMethod = new GetMethod(this.baseUrl + servicePath);
        if (params != null) {
            ArrayList<NameValuePair> args = new ArrayList<NameValuePair>();
            for (WebscriptParam param : params) {
                args.add(new NameValuePair(param.getName(), param.getValue()));
            }
            getMethod.setQueryString(args.toArray(new NameValuePair[args.size()]));
        }
        return getMethod;
    }

    PostMethod getPOSTMethod(String servicePath, List<WebscriptParam> params) {
        PostMethod postMethod = new PostMethod(this.baseUrl + servicePath);
        if (params != null) {
            ArrayList<NameValuePair> args = new ArrayList<NameValuePair>();
            for (WebscriptParam param : params) {
                args.add(new NameValuePair(param.getName(), param.getValue()));
            }
            postMethod.addParameters(args.toArray(new NameValuePair[args.size()]));
        }
        return postMethod;
    }

    @Override
    public JSONObject getJsonObject(String servicePath, WebscriptParam ... params) {
        return this.getJsonObject(servicePath, Arrays.asList(params));
    }

    @Override
    public void get(String servicePath, WebscriptResponseHandler handler, WebscriptParam ... params) {
        this.get(servicePath, handler, Arrays.asList(params));
    }

    private static class TicketResponseHandler
    extends DefaultHandler
    implements WebscriptResponseHandler {
        private String ticket = null;
        private StringBuilder ticketChars;

        private TicketResponseHandler() {
        }

        @Override
        public void handleResponse(InputStream in) {
            SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
            try {
                SAXParser parser = saxParserFactory.newSAXParser();
                parser.parse(in, (DefaultHandler)this);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.ticketChars != null) {
                this.ticketChars.append(ch, start, length);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if ("ticket".equals(qName) && this.ticketChars != null) {
                this.ticket = this.ticketChars.toString();
                this.ticketChars = null;
            }
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if ("ticket".equals(qName)) {
                this.ticketChars = new StringBuilder();
            }
        }
    }

    private static class JsonResponseHandler
    implements WebscriptResponseHandler {
        public JSONObject jsonObject;

        private JsonResponseHandler() {
        }

        @Override
        public void handleResponse(InputStream in) {
            try {
                this.jsonObject = new JSONObject(new JSONTokener((Reader)new InputStreamReader(in, "UTF-8")));
            }
            catch (JSONException ex) {
                log.error((Object)"Failed to parse response from Alfresco", (Throwable)ex);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
    }
}

