/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.wcm.client.util.impl;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.StringTokenizer;
import org.alfresco.wcm.client.Asset;
import org.alfresco.wcm.client.Section;
import org.alfresco.wcm.client.WebSite;
import org.alfresco.wcm.client.util.CmisIdEncoder;
import org.alfresco.wcm.client.util.UrlUtils;

public class UrlUtilsImpl
implements UrlUtils {
    private CmisIdEncoder cmisIdEncoder;

    @Override
    public String getUrl(Asset asset) {
        boolean image;
        boolean bl = image = asset.getMimeType() != null && asset.getMimeType().startsWith("image/");
        if (image) {
            return this.getShortUrl(asset);
        }
        return this.getLongUrl(asset);
    }

    @Override
    public String getShortUrl(Asset asset) {
        try {
            return "/asset/" + this.cmisIdEncoder.getUrlSafeString(asset.getId()) + "/" + URLEncoder.encode(asset.getName(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getLongUrl(Asset asset) {
        try {
            return asset.getContainingSection().getPath() + URLEncoder.encode(asset.getName(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String decodeResourceName(String resourceName) {
        try {
            return URLDecoder.decode(resourceName, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getUrl(Section section) {
        return section.getPath();
    }

    @Override
    public String getAssetIdFromShortUrl(String uri) {
        StringTokenizer st = new StringTokenizer(uri, "/");
        String prefix = st.nextToken();
        if (!prefix.equals("asset") || st.countTokens() < 1 || st.countTokens() > 2 || uri.trim().endsWith("/")) {
            throw new IllegalArgumentException("Asset URL expected to be in format /asset/{url-safe-object-id}/{filename} or /asset/{url-safe-object-id}");
        }
        String urlSafeObjectId = st.nextToken();
        String objectId = this.cmisIdEncoder.getObjectId(urlSafeObjectId);
        return objectId;
    }

    public void setCmisIdEncoder(CmisIdEncoder cmisIdEncoder) {
        this.cmisIdEncoder = cmisIdEncoder;
    }

    @Override
    public String getWebsiteDomain(WebSite webSite) {
        return "http://" + webSite.getHostName() + (String)(webSite.getHostPort() == 80 ? "" : ":" + webSite.getHostPort() + "/" + webSite.getContext());
    }
}

