/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.wcm.client.impl;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.alfresco.wcm.client.Asset;
import org.alfresco.wcm.client.AssetCollection;
import org.alfresco.wcm.client.AssetFactory;
import org.alfresco.wcm.client.CollectionFactory;
import org.alfresco.wcm.client.ResourceNotFoundException;
import org.alfresco.wcm.client.Section;
import org.alfresco.wcm.client.SectionFactory;
import org.alfresco.wcm.client.impl.AssetCollectionImpl;
import org.alfresco.wcm.client.util.CmisSessionHelper;
import org.alfresco.wcm.client.util.SqlUtils;
import org.apache.chemistry.opencmis.client.api.ItemIterable;
import org.apache.chemistry.opencmis.client.api.OperationContext;
import org.apache.chemistry.opencmis.client.api.QueryResult;
import org.apache.chemistry.opencmis.client.api.Relationship;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.commons.enums.IncludeRelationships;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CollectionFactoryCmisImpl
implements CollectionFactory {
    private static final Log log = LogFactory.getLog(CollectionFactoryCmisImpl.class);
    private static final String COLUMNS = "f.cmis:objectId, f.cmis:name, t.cm:title, t.cm:description";
    private static final String QUERY = "select f.cmis:objectId, f.cmis:name, t.cm:title, t.cm:description from cmis:folder as f join cm:titled as t on t.cmis:objectId = f.cmis:objectId ";
    private static final String QUERY_COLLECTION = "select f.cmis:objectId, f.cmis:name, t.cm:title, t.cm:description from cmis:folder as f join cm:titled as t on t.cmis:objectId = f.cmis:objectId where in_folder(f, {0}) and f.cmis:name = {1}";
    private SectionFactory sectionFactory;
    private AssetFactory assetFactory;

    private AssetCollectionImpl buildCollection(QueryResult result) {
        AssetCollectionImpl collection = new AssetCollectionImpl();
        return collection;
    }

    private List<String> buildRelatedAssetList(QueryResult result) {
        ArrayList<String> relatedIds = new ArrayList<String>();
        List relationships = result.getRelationships();
        for (Relationship relationship : relationships) {
            String name = (String)relationship.getPropertyValue("cmis:name");
            String targetId = (String)relationship.getPropertyValue("cmis:targetId");
            log.debug((Object)(name + " " + targetId));
            relatedIds.add(targetId);
        }
        return relatedIds;
    }

    @Override
    public AssetCollection getCollection(String sectionId, String collectionName) {
        if (sectionId == null || sectionId.length() == 0) {
            throw new IllegalArgumentException("sectionId must be supplied");
        }
        if (collectionName == null || collectionName.length() == 0) {
            throw new IllegalArgumentException("collectionName must be supplied");
        }
        Section section = this.sectionFactory.getSection(sectionId);
        Session session = CmisSessionHelper.getSession();
        String cquery = MessageFormat.format(QUERY_COLLECTION, SqlUtils.encloseSQLString(collectionName));
        log.debug((Object)("Querying " + cquery));
        OperationContext oc = session.createOperationContext();
        oc.setIncludeRelationships(IncludeRelationships.SOURCE);
        ItemIterable cresults = session.query(cquery, false, oc);
        if (cresults.getTotalNumItems() == 0L) {
            throw new ResourceNotFoundException(section.getId() + "/" + collectionName);
        }
        QueryResult cresult = (QueryResult)cresults.iterator().next();
        AssetCollectionImpl collection = this.buildCollection(cresult);
        List<String> assetIds = this.buildRelatedAssetList(cresult);
        if (assetIds.size() > 0) {
            List<Asset> assets = this.assetFactory.getAssetsById(assetIds);
            collection.setAssets(assets);
        }
        return collection;
    }

    public void setSectionFactory(SectionFactory sectionFactory) {
        this.sectionFactory = sectionFactory;
    }

    public void setAssetFactory(AssetFactory assetFactory) {
        this.assetFactory = assetFactory;
    }

    @Override
    public AssetCollection getCollection(String sectionId, String collectionName, int resultsToSkip, int maxResults) {
        return null;
    }
}

