/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.wcm.client.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.alfresco.wcm.client.Section;
import org.alfresco.wcm.client.WebSite;
import org.alfresco.wcm.client.WebSiteService;
import org.alfresco.wcm.client.impl.AbstractCachingSectionFactoryImpl;
import org.alfresco.wcm.client.impl.AssetDeserializerXmlImpl;
import org.alfresco.wcm.client.impl.SectionImpl;
import org.alfresco.wcm.client.impl.WebScriptCaller;
import org.alfresco.wcm.client.impl.WebscriptParam;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SectionFactoryWebscriptImpl
extends AbstractCachingSectionFactoryImpl {
    private ThreadLocal<List<WebscriptParam>> localParamList = new ThreadLocal<List<WebscriptParam>>(){

        @Override
        protected List<WebscriptParam> initialValue() {
            return new ArrayList<WebscriptParam>();
        }

        @Override
        public List<WebscriptParam> get() {
            List list = (List)super.get();
            list.clear();
            return list;
        }
    };
    private static final Log log = LogFactory.getLog(SectionFactoryWebscriptImpl.class);
    private WebScriptCaller webscriptCaller;

    public void setWebscriptCaller(WebScriptCaller webscriptCaller) {
        this.webscriptCaller = webscriptCaller;
    }

    protected AbstractCachingSectionFactoryImpl.SectionDetails buildSection(TreeMap<String, Serializable> result) {
        AbstractCachingSectionFactoryImpl.SectionDetails sectionDetails = new AbstractCachingSectionFactoryImpl.SectionDetails(this);
        SectionImpl section = new SectionImpl();
        section.setProperties(result);
        List tagSummary = (List)((Object)result.get("cm:tagScopeSummary"));
        section.setTags(this.createTags(tagSummary));
        section.setSectionFactory(this);
        section.setAssetFactory(this.getAssetFactory());
        section.setDictionaryService(this.getDictionaryService());
        section.setCollectionFactory(this.getCollectionFactory());
        sectionDetails.section = section;
        sectionDetails.objectTypeId = (String)((Object)result.get("type"));
        if (!sectionDetails.objectTypeId.equals("ws:webroot")) {
            String parentId = (String)((Object)result.get("ws:parentId"));
            section.setPrimarySectionId(parentId);
            sectionDetails.parentId = parentId;
        }
        return sectionDetails;
    }

    @Override
    protected Map<String, Section> findSectionWithChildren(String topSectionId) {
        if (log.isDebugEnabled()) {
            log.debug((Object)(Thread.currentThread().getName() + " loading section tree starting at " + topSectionId));
        }
        TreeMap<String, Section> loadedSections = new TreeMap<String, Section>();
        List<WebscriptParam> params = this.localParamList.get();
        params.add(new WebscriptParam("sectionId", topSectionId));
        params.add(new WebscriptParam("includeChildren", "true"));
        WebSite currentSite = WebSiteService.getThreadWebSite();
        if (currentSite != null) {
            params.add(new WebscriptParam("siteId", currentSite.getId()));
        }
        AssetDeserializerXmlImpl deserializer = new AssetDeserializerXmlImpl();
        this.webscriptCaller.post("websection", deserializer, params);
        LinkedList<TreeMap<String, Serializable>> sectionList = deserializer.getAssets();
        ArrayList<AbstractCachingSectionFactoryImpl.SectionDetails> orderedList = new ArrayList<AbstractCachingSectionFactoryImpl.SectionDetails>();
        for (TreeMap treeMap : sectionList) {
            AbstractCachingSectionFactoryImpl.SectionDetails sectionDetails = this.buildSection(treeMap);
            orderedList.add(sectionDetails);
            loadedSections.put(sectionDetails.section.getId(), sectionDetails.section);
        }
        for (AbstractCachingSectionFactoryImpl.SectionDetails sectionDetails : orderedList) {
            if (sectionDetails.section.getId().equals(topSectionId)) continue;
            SectionImpl parent = (SectionImpl)loadedSections.get(sectionDetails.parentId);
            parent.addChild(sectionDetails.section);
        }
        return loadedSections;
    }
}

