/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.wcm.client.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import org.alfresco.wcm.client.Rendition;
import org.alfresco.wcm.client.impl.StreamUtils;
import org.apache.chemistry.opencmis.commons.data.ContentStream;

public class ContentStreamCmisRenditionImpl
implements Rendition {
    private final org.apache.chemistry.opencmis.client.api.Rendition cmisRendition;
    private ContentStream cmisContentStream;

    public ContentStreamCmisRenditionImpl(org.apache.chemistry.opencmis.client.api.Rendition cmisRendition) {
        this.cmisRendition = cmisRendition;
    }

    @Override
    public String getFileName() {
        return this.getContentStream().getFileName();
    }

    @Override
    public long getLength() {
        return this.cmisRendition.getLength();
    }

    @Override
    public String getMimeType() {
        return this.cmisRendition.getMimeType();
    }

    @Override
    public InputStream getStream() {
        return this.getContentStream().getStream();
    }

    private ContentStream getContentStream() {
        if (this.cmisContentStream == null) {
            this.cmisContentStream = this.cmisRendition.getContentStream();
        }
        return this.cmisContentStream;
    }

    @Override
    public long getHeight() {
        return this.cmisRendition.getHeight();
    }

    @Override
    public long getWidth() {
        return this.cmisRendition.getWidth();
    }

    @Override
    public void output(OutputStream output) throws IOException {
        StreamUtils.output(this.getContentStream().getStream(), output);
    }

    @Override
    public void write(Writer writer) throws IOException {
        this.write(writer, "UTF-8");
    }

    @Override
    public void write(Writer writer, String encoding) throws IOException {
        StreamUtils.write(this.getContentStream().getStream(), writer, encoding);
    }
}

