/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.wcm.client.util.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.wcm.client.exception.RepositoryUnavailableException;
import org.apache.chemistry.opencmis.client.api.Repository;
import org.apache.chemistry.opencmis.client.bindings.spi.AbstractAuthenticationProvider;
import org.apache.chemistry.opencmis.client.runtime.SessionFactoryImpl;
import org.apache.chemistry.opencmis.commons.enums.BindingType;
import org.apache.chemistry.opencmis.commons.spi.AuthenticationProvider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.pool.PoolableObjectFactory;

public class GuestSessionFactoryImpl
implements PoolableObjectFactory,
Runnable {
    private static final Log log = LogFactory.getLog(GuestSessionFactoryImpl.class);
    private int repositoryPollInterval;
    private Repository repository;
    private SessionFactoryImpl sessionFactory;
    private Map<String, String> parameters;
    private volatile Thread waitForRepository;
    private Exception lastException;
    private AbstractAuthenticationProvider authenticationProvider;
    private String repoUrl;
    private String username;
    private String password;

    public void setRepositoryPollInterval(int repositoryPollInterval) {
        this.repositoryPollInterval = repositoryPollInterval;
    }

    public void setAuthenticationProvider(AbstractAuthenticationProvider authenticationProvider) {
        this.authenticationProvider = authenticationProvider;
    }

    public void setRepoUrl(String repoUrl) {
        this.repoUrl = repoUrl;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void init() {
        if (this.repositoryPollInterval > 0) {
            this.waitForRepository = new Thread(this);
            this.waitForRepository.start();
        } else {
            this.getRepository();
        }
    }

    private void configureSessionFactory() {
        if (this.sessionFactory == null) {
            this.parameters = new HashMap<String, String>();
            this.parameters.put("org.apache.chemistry.opencmis.user", this.username);
            this.parameters.put("org.apache.chemistry.opencmis.password", this.password);
            this.parameters.put("org.apache.chemistry.opencmis.binding.atompub.url", this.repoUrl);
            this.parameters.put("org.apache.chemistry.opencmis.binding.spi.type", BindingType.ATOMPUB.value());
            this.sessionFactory = SessionFactoryImpl.newInstance();
        }
    }

    private void getRepository() {
        this.configureSessionFactory();
        List repositories = this.sessionFactory.getRepositories(this.parameters, null, (AuthenticationProvider)this.authenticationProvider, null, null);
        this.repository = (Repository)repositories.get(0);
    }

    @Override
    public void run() {
        Thread thisThread = Thread.currentThread();
        while (this.waitForRepository == thisThread) {
            try {
                this.getRepository();
                log.info((Object)"Repository available");
                break;
            }
            catch (Exception e) {
                this.lastException = e;
                log.warn((Object)("WQS unable to connect to repository: " + e.getMessage()));
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Caught exception while attempting to connect to repository over CMIS", (Throwable)e);
                }
                try {
                    Thread.sleep(this.repositoryPollInterval);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        this.waitForRepository = null;
    }

    public void stop() {
        this.waitForRepository = null;
    }

    public void activateObject(Object obj) throws Exception {
    }

    public void destroyObject(Object obj) throws Exception {
    }

    public Object makeObject() throws Exception {
        if (this.repository == null) {
            throw new RepositoryUnavailableException(this.lastException);
        }
        return this.repository.createSession();
    }

    public void passivateObject(Object obj) throws Exception {
    }

    public boolean validateObject(Object obj) {
        return true;
    }
}

