/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.wcm.client.impl;

import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.alfresco.wcm.client.Asset;
import org.alfresco.wcm.client.AssetFactory;
import org.alfresco.wcm.client.SectionFactory;
import org.alfresco.wcm.client.UgcService;
import org.alfresco.wcm.client.WebSite;
import org.alfresco.wcm.client.WebSiteService;
import org.alfresco.wcm.client.impl.UgcServiceCmisImpl;
import org.alfresco.wcm.client.impl.WebScriptCaller;
import org.alfresco.wcm.client.impl.WebSiteImpl;
import org.alfresco.wcm.client.impl.WebscriptParam;
import org.alfresco.wcm.client.impl.cache.SimpleCache;
import org.alfresco.wcm.client.util.CmisSessionHelper;
import org.apache.chemistry.opencmis.client.api.ItemIterable;
import org.apache.chemistry.opencmis.client.api.QueryResult;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONObject;

public class WebSiteServiceImpl
extends WebSiteService {
    private static final Log log = LogFactory.getLog(WebSiteServiceImpl.class);
    private static final String QUERY_WEB_ROOTS = "select f.cmis:objectId, w.ws:hostName, w.ws:hostPort, t.cm:title, t.cm:description, w.ws:webAppContext, w.ws:siteConfig from cmis:folder as f join ws:website as w on w.cmis:objectId = f.cmis:objectId join cm:titled as t on t.cmis:objectId = f.cmis:objectId";
    private Map<String, WebSite> webSiteCache;
    private long webSiteCacheRefeshedAt;
    private int webSiteCacheRefreshAfter = 60;
    private int webSiteSectionCacheRefreshAfter = 60;
    private SectionFactory sectionFactory;
    private AssetFactory assetFactory;
    private WebScriptCaller webscriptCaller;
    private SimpleCache<String, String> formIdCache;
    private String logoFilename;

    public void setWebSiteCacheRefreshAfter(int webSiteCacheRefreshAfter) {
        this.webSiteCacheRefreshAfter = webSiteCacheRefreshAfter;
    }

    public void setWebSiteSectionCacheRefreshAfter(int webSiteSectionCacheRefreshAfter) {
        this.webSiteSectionCacheRefreshAfter = webSiteSectionCacheRefreshAfter;
    }

    @Override
    public WebSite getWebSite(String hostName, int hostPort) {
        return this.getWebSite(hostName, hostPort, null);
    }

    @Override
    public WebSite getWebSite(String hostName, int hostPort, String contextPath) {
        if (contextPath == null) {
            contextPath = "/";
        } else if (!((String)contextPath).startsWith("/")) {
            contextPath = "/" + (String)contextPath;
        }
        String key = (hostName + ":" + hostPort).toLowerCase() + (String)contextPath;
        WebSite website = this.getWebSiteCache().get(key);
        if (website == null) {
            this.refreshWebsiteCache();
            website = this.getWebSiteCache().get(key);
        }
        if (website == null) {
            log.warn((Object)("Received a request for unrecognised host+port: " + key));
        }
        return website;
    }

    @Override
    public Collection<WebSite> getWebSites() {
        return this.getWebSiteCache().values();
    }

    private Map<String, WebSite> getWebSiteCache() {
        if (this.webSiteCache == null || this.webSiteCacheExpired()) {
            this.refreshWebsiteCache();
        }
        return this.webSiteCache;
    }

    private void refreshWebsiteCache() {
        HashMap<String, WebSite> newCache = new HashMap<String, WebSite>(5);
        Session session = CmisSessionHelper.getSession();
        if (log.isDebugEnabled()) {
            log.debug((Object)"About to run CMIS query: select f.cmis:objectId, w.ws:hostName, w.ws:hostPort, t.cm:title, t.cm:description, w.ws:webAppContext, w.ws:siteConfig from cmis:folder as f join ws:website as w on w.cmis:objectId = f.cmis:objectId join cm:titled as t on t.cmis:objectId = f.cmis:objectId");
        }
        ItemIterable results = session.query(QUERY_WEB_ROOTS, false);
        for (QueryResult result : results) {
            String id = (String)result.getPropertyValueById("cmis:objectId");
            String hostName = (String)result.getPropertyValueById("ws:hostName");
            BigInteger hostPort = (BigInteger)result.getPropertyValueById("ws:hostPort");
            String context = (String)result.getPropertyValueById("ws:webAppContext");
            if (context == null) {
                context = "";
            }
            if (context.startsWith("/")) {
                context = context.substring(1);
            }
            if (hostPort == null) {
                hostPort = new BigInteger("80");
            }
            String key = (hostName + ":" + hostPort.toString()).toLowerCase() + "/" + context;
            String title = (String)result.getPropertyValueById("cm:title");
            String description = (String)result.getPropertyValueById("cm:description");
            List configList = result.getPropertyMultivalueById("ws:siteConfig");
            Map<String, String> configProperties = this.parseSiteConfig(configList);
            WebsiteInfo siteInfo = this.getWebsiteInfo(id);
            WebSiteImpl webSite = new WebSiteImpl(id, hostName, hostPort.intValue(), this.webSiteSectionCacheRefreshAfter);
            webSite.setRootSectionId(siteInfo.rootSectionId);
            webSite.setTitle(title);
            webSite.setDescription(description);
            webSite.setContext(context);
            webSite.setSectionFactory(this.sectionFactory);
            webSite.setConfig(configProperties);
            webSite.setUgcService(this.createUgcService(session, siteInfo));
            newCache.put(key, webSite);
            Asset logo = this.assetFactory.getSectionAsset(siteInfo.rootSectionId, this.logoFilename, true);
            webSite.setLogo(logo);
        }
        this.webSiteCacheRefeshedAt = System.currentTimeMillis();
        this.webSiteCache = newCache;
    }

    protected UgcService createUgcService(Session session, WebsiteInfo siteInfo) {
        UgcServiceCmisImpl ugcService = new UgcServiceCmisImpl(session.createObjectId(siteInfo.feedbackFolderId));
        ugcService.setFormIdCache(this.formIdCache);
        return ugcService;
    }

    private Map<String, String> parseSiteConfig(List<String> configList) {
        TreeMap<String, String> result = new TreeMap<String, String>();
        if (configList != null) {
            for (String configValue : configList) {
                String[] split = configValue.split("=", -1);
                if (split.length != 2) continue;
                result.put(split[0], split[1]);
            }
        }
        return result;
    }

    private WebsiteInfo getWebsiteInfo(String websiteid) {
        String feedbackFolderId = websiteid;
        String rootSectionId = websiteid;
        try {
            WebscriptParam[] params = new WebscriptParam[]{new WebscriptParam("websiteid", websiteid)};
            JSONObject jsonObject = this.webscriptCaller.getJsonObject("websiteinfo", Arrays.asList(params));
            if (jsonObject != null) {
                JSONObject data = (JSONObject)jsonObject.get("data");
                feedbackFolderId = data.getString("feedbackfolderid");
                rootSectionId = data.getString("rootsectionid");
            }
        }
        catch (Exception ex) {
            log.error((Object)("Error while attempting to retrieve feedback folder for website " + websiteid), (Throwable)ex);
        }
        return new WebsiteInfo(rootSectionId, feedbackFolderId);
    }

    private boolean webSiteCacheExpired() {
        long calcValue;
        boolean result = true;
        long now = System.currentTimeMillis();
        long difference = now - this.webSiteCacheRefeshedAt;
        if (difference <= (calcValue = (long)(this.webSiteCacheRefreshAfter * 1000))) {
            result = false;
        }
        return result;
    }

    public void setLogoFilename(String logoFilename) {
        this.logoFilename = logoFilename;
    }

    public void setSectionFactory(SectionFactory sectionFactory) {
        this.sectionFactory = sectionFactory;
    }

    public void setAssetFactory(AssetFactory assetFactory) {
        this.assetFactory = assetFactory;
    }

    public void setWebscriptCaller(WebScriptCaller webscriptCaller) {
        this.webscriptCaller = webscriptCaller;
    }

    public void setFormIdCache(SimpleCache<String, String> formIdCache) {
        this.formIdCache = formIdCache;
    }

    public static final class WebsiteInfo {
        public final String rootSectionId;
        public final String feedbackFolderId;

        public WebsiteInfo(String rootSectionId, String feedbackFolderId) {
            this.rootSectionId = rootSectionId;
            this.feedbackFolderId = feedbackFolderId;
        }
    }
}

