/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.wcm.client.util.impl;

import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.alfresco.wcm.client.util.CmisSessionPool;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.commons.pool.ObjectPool;

public class CmisSessionPoolImpl
implements CmisSessionPool {
    private ObjectPool guestSessionPool;
    private Session session;
    private ReadWriteLock sessionLock = new ReentrantReadWriteLock(true);
    private long ticketDuration = 3600000L;
    private AtomicLong sessionLastTouched = new AtomicLong(System.currentTimeMillis());

    public CmisSessionPoolImpl(ObjectPool guestSessionPool, long ticketDuration) {
        this.guestSessionPool = guestSessionPool;
        this.ticketDuration = ticketDuration;
    }

    @Override
    public synchronized void closeSession(Session session) throws Exception {
    }

    @Override
    public Session getGuestSession() throws Exception {
        this.sessionLock.readLock().lock();
        boolean refreshSession = System.currentTimeMillis() >= this.sessionLastTouched.get() + this.ticketDuration;
        try {
            if (refreshSession || this.session == null) {
                this.sessionLock.readLock().unlock();
                this.sessionLock.writeLock().lock();
                try {
                    boolean bl = refreshSession = System.currentTimeMillis() >= this.sessionLastTouched.get() + this.ticketDuration;
                    if (refreshSession || this.session == null) {
                        if (this.session != null) {
                            this.guestSessionPool.invalidateObject((Object)this.session);
                        }
                        this.session = (Session)this.guestSessionPool.borrowObject();
                    }
                }
                finally {
                    this.sessionLock.readLock().lock();
                    this.sessionLock.writeLock().unlock();
                }
            }
            this.sessionLastTouched.set(System.currentTimeMillis());
            Session session = this.session;
            return session;
        }
        finally {
            this.sessionLock.readLock().unlock();
        }
    }

    @Override
    public synchronized Session getSession(String username, String password) {
        throw new UnsupportedOperationException("Custom authenticated sessions not yet supported by this class");
    }
}

