/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.wcm.client.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.alfresco.wcm.client.Asset;
import org.alfresco.wcm.client.AssetCollection;
import org.alfresco.wcm.client.Query;
import org.alfresco.wcm.client.impl.ResourceBaseImpl;

public class AssetCollectionImpl
extends ResourceBaseImpl
implements AssetCollection {
    private static final long serialVersionUID = 1L;
    private List<String> assetIds = new ArrayList<String>();
    private boolean isDynamic;
    private Date refreshTime;
    protected List<Asset> assets = new ArrayList<Asset>();
    private Query query;
    private long totalSize;

    @Override
    public void setProperties(Map<String, Serializable> props) {
        super.setProperties(props);
        this.assetIds = (List)((Object)props.get("ws:containedAssets"));
        this.refreshTime = (Date)props.get("ws:refreshAt");
        this.isDynamic = (Boolean)props.get("ws:isDynamic");
        this.totalSize = this.assetIds == null ? 0L : (long)this.assetIds.size();
    }

    @Override
    public List<Asset> getAssets() {
        return Collections.unmodifiableList(this.assets);
    }

    public void setAssets(List<Asset> assets) {
        this.assets = assets;
    }

    public void add(Asset asset) {
        this.assets.add(asset);
    }

    @Override
    public Query getQuery() {
        return this.query;
    }

    @Override
    public long getSize() {
        return this.assets.size();
    }

    @Override
    public long getTotalSize() {
        return this.totalSize;
    }

    public void setQuery(Query query) {
        this.query = query;
    }

    @Override
    public List<String> getAssetIds() {
        return Collections.unmodifiableList(this.assetIds);
    }

    public void setAssetIds(List<String> assetIds) {
        this.assetIds = assetIds;
    }

    @Override
    public Date getNextRefreshTime() {
        return this.refreshTime;
    }
}

