/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.wcm.client.impl;

import java.util.Date;
import java.util.List;
import org.alfresco.wcm.client.Asset;
import org.alfresco.wcm.client.AssetCollection;
import org.alfresco.wcm.client.AssetCollectionFactory;
import org.alfresco.wcm.client.AssetFactory;
import org.alfresco.wcm.client.Query;
import org.alfresco.wcm.client.WebSite;
import org.alfresco.wcm.client.WebSiteService;
import org.alfresco.wcm.client.impl.AssetCollectionImpl;
import org.alfresco.wcm.client.impl.cache.SimpleCache;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CachingAssetCollectionFactoryImpl
implements AssetCollectionFactory {
    private static final Log log = LogFactory.getLog(CachingAssetCollectionFactoryImpl.class);
    private AssetCollectionFactory delegate;
    private SimpleCache<String, CacheEntry> cache;
    private long minimumCacheMilliseconds = 30000L;
    private AssetFactory assetFactory;

    @Override
    public AssetCollection getCollection(String sectionId, String collectionName, int resultsToSkip, int maxResults) {
        AssetCollection result = null;
        String cacheKey = sectionId + "/" + collectionName;
        CacheEntry cacheEntry = this.cache.get(cacheKey);
        long now = System.currentTimeMillis();
        long earliestPermittedCacheTime = now - this.getMinimumCacheMilliseconds();
        if (cacheEntry == null) {
            AssetCollectionImpl cachedAssetCollection;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Failed to find asset collection in cache: " + cacheKey));
            }
            if ((cachedAssetCollection = this.copyAssetCollection(result = this.delegate.getCollection(sectionId, collectionName, resultsToSkip, maxResults))) != null) {
                this.cache.put(cacheKey, new CacheEntry(cachedAssetCollection));
            }
        } else {
            AssetCollectionImpl cachedAssetCollection = cacheEntry.assetCollection;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Found an asset collection in the cache. now == " + now + "; cache time == " + cacheEntry.cacheTime));
            }
            if (cacheEntry.cacheTime < earliestPermittedCacheTime) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Checking whether we need to reload asset collection");
                }
                cacheEntry.cacheTime = now;
                Date nextRefreshTime = cachedAssetCollection.getNextRefreshTime();
                if (earliestPermittedCacheTime != now && nextRefreshTime != null) {
                    long nextRefreshTimeMillis = nextRefreshTime.getTime();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Found asset collection has a refresh time of " + nextRefreshTimeMillis));
                    }
                    if (now > nextRefreshTimeMillis) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Reloading asset collection " + cacheKey));
                        }
                        if ((cachedAssetCollection = this.copyAssetCollection(result = this.delegate.getCollection(sectionId, collectionName, resultsToSkip, maxResults))) != null) {
                            this.cache.put(cacheKey, new CacheEntry(cachedAssetCollection));
                        }
                    }
                } else {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Found asset collection has no refresh time set. Checking modified time.");
                    }
                    Date currentModifiedTime = this.delegate.getModifiedTimeOfAssetCollection(cachedAssetCollection.getId());
                    Date cachedModifiedTime = (Date)cachedAssetCollection.getProperty("cmis:lastModificationDate");
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Cached modified time == " + cachedModifiedTime.getTime() + "; Current modified time == " + currentModifiedTime.getTime()));
                    }
                    if (currentModifiedTime.after(cachedModifiedTime)) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Reloading asset collection " + cacheKey));
                        }
                        if ((cachedAssetCollection = this.copyAssetCollection(result = this.delegate.getCollection(sectionId, collectionName, resultsToSkip, maxResults))) != null) {
                            this.cache.put(cacheKey, new CacheEntry(cachedAssetCollection));
                        }
                    }
                }
            }
            if (result == null) {
                AssetCollectionImpl resultImpl = this.copyAssetCollection(cachedAssetCollection);
                Query query = new Query();
                query.setSectionId(sectionId);
                query.setMaxResults(maxResults);
                query.setResultsToSkip(resultsToSkip);
                resultImpl.setQuery(query);
                List<String> assetIds = resultImpl.getAssetIds();
                if (assetIds.size() > 0) {
                    if (maxResults != -1) {
                        int end = resultsToSkip + maxResults;
                        assetIds = assetIds.subList(resultsToSkip, end > assetIds.size() ? assetIds.size() : end);
                    }
                    List<Asset> assets = this.assetFactory.getAssetsById(assetIds);
                    resultImpl.setAssets(assets);
                }
                result = resultImpl;
            }
        }
        return result;
    }

    protected AssetCollectionImpl copyAssetCollection(AssetCollection objToCopy) {
        AssetCollectionImpl copy = null;
        if (objToCopy != null && AssetCollectionImpl.class.isAssignableFrom(objToCopy.getClass())) {
            copy = new AssetCollectionImpl();
            AssetCollectionImpl other = (AssetCollectionImpl)objToCopy;
            copy.setAssetFactory(other.getAssetFactory());
            copy.setCollectionFactory(other.getCollectionFactory());
            copy.setSectionFactory(other.getSectionFactory());
            copy.setProperties(other.getProperties());
            copy.setPrimarySectionId(other.getPrimarySectionId());
        }
        return copy;
    }

    @Override
    public AssetCollection getCollection(String sectionId, String collectionName) {
        return this.getCollection(sectionId, collectionName, 0, -1);
    }

    @Override
    public Date getModifiedTimeOfAssetCollection(String assetCollectionId) {
        return this.delegate.getModifiedTimeOfAssetCollection(assetCollectionId);
    }

    public void setDelegate(AssetCollectionFactory delegate) {
        this.delegate = delegate;
    }

    public void setCache(SimpleCache<String, CacheEntry> cache) {
        this.cache = cache;
    }

    public void setMinimumCacheMilliseconds(long minimumCacheMilliseconds) {
        this.minimumCacheMilliseconds = minimumCacheMilliseconds;
    }

    public void setAssetFactory(AssetFactory assetFactory) {
        this.assetFactory = assetFactory;
    }

    private long getMinimumCacheMilliseconds() {
        long result = 0L;
        WebSite currentSite = WebSiteService.getThreadWebSite();
        if (currentSite == null || !currentSite.isEditorialSite()) {
            result = this.minimumCacheMilliseconds;
        }
        return result;
    }

    private static class CacheEntry {
        public long cacheTime;
        public final AssetCollectionImpl assetCollection;

        public CacheEntry(AssetCollectionImpl assetCollection) {
            this.assetCollection = assetCollection;
            this.cacheTime = System.currentTimeMillis();
        }
    }
}

