/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.wcm.client.impl;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.alfresco.wcm.client.Asset;
import org.alfresco.wcm.client.AssetFactory;
import org.alfresco.wcm.client.ContentStream;
import org.alfresco.wcm.client.Rendition;
import org.alfresco.wcm.client.Section;

public class DeferredLoadingAssetImpl
implements Asset {
    private static final long serialVersionUID = -6315185984769557540L;
    private AssetFactory assetFactory;
    private String id;
    private Asset delegate;

    public DeferredLoadingAssetImpl(String assetId, AssetFactory assetFactory) {
        this.id = assetId;
        this.assetFactory = assetFactory;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Section getContainingSection() {
        return this.getDelegate().getContainingSection();
    }

    @Override
    public ContentStream getContentAsInputStream() {
        return this.getDelegate().getContentAsInputStream();
    }

    @Override
    public String getDescription() {
        return this.getDelegate().getDescription();
    }

    @Override
    public String getMimeType() {
        return this.getDelegate().getMimeType();
    }

    @Override
    public String getName() {
        return this.getDelegate().getName();
    }

    @Override
    public Map<String, Serializable> getProperties() {
        return this.getDelegate().getProperties();
    }

    @Override
    public Serializable getProperty(String name) {
        return this.getDelegate().getProperty(name);
    }

    @Override
    public Asset getRelatedAsset(String relationshipName) {
        return this.getDelegate().getRelatedAsset(relationshipName);
    }

    @Override
    public Map<String, List<Asset>> getRelatedAssets() {
        return this.getDelegate().getRelatedAssets();
    }

    @Override
    public List<Asset> getRelatedAssets(String relationshipName) {
        return this.getDelegate().getRelatedAssets(relationshipName);
    }

    @Override
    public Map<String, Rendition> getRenditions() {
        return this.getDelegate().getRenditions();
    }

    @Override
    public long getSize() {
        return this.getDelegate().getSize();
    }

    @Override
    public List<String> getTags() {
        return this.getDelegate().getTags();
    }

    @Override
    public String getTemplate() {
        return this.getDelegate().getTemplate();
    }

    @Override
    public String getTitle() {
        return this.getDelegate().getTitle();
    }

    @Override
    public String getType() {
        return this.getDelegate().getType();
    }

    private Asset getDelegate() {
        if (this.delegate == null) {
            this.delegate = this.assetFactory.getAssetById(this.id, false);
        }
        return this.delegate;
    }
}

