/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.wcm.client;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.TreeMap;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;
import org.alfresco.wcm.client.BaseTest;
import org.alfresco.wcm.client.Section;
import org.alfresco.wcm.client.WebSite;
import org.alfresco.wcm.client.impl.SectionFactoryCmisImpl;
import org.alfresco.wcm.client.impl.SectionFactoryWebscriptImpl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SectionFactoryTest
extends BaseTest {
    private static final Log log = LogFactory.getLog(SectionFactoryTest.class);

    public void testGetSections() {
        WebSite site = this.getWebSite();
        Section root = site.getRootSection();
        String rootId = root.getId();
        Section section = this.sectionFactory.getSectionFromPathSegments(rootId, new String[]{"news"});
        SectionFactoryTest.assertNotNull((Object)section);
        Section bad = this.sectionFactory.getSectionFromPathSegments(rootId, new String[]{"news", "wooble"});
        SectionFactoryTest.assertNull((Object)bad);
        Section exists2 = this.sectionFactory.getSection(section.getId());
        SectionFactoryTest.assertNotNull((Object)exists2);
        log.debug((Object)section.getProperties());
    }

    public void testConcurrentGetSections() {
        final WebSite site = this.getWebSite();
        final TreeMap<String, List<String>> expectedSections = new TreeMap<String, List<String>>();
        if (SectionFactoryCmisImpl.class.isAssignableFrom(this.sectionFactory.getClass())) {
            ((SectionFactoryCmisImpl)this.sectionFactory).setSectionsRefreshAfter(20);
        } else if (SectionFactoryWebscriptImpl.class.isAssignableFrom(this.sectionFactory.getClass())) {
            ((SectionFactoryWebscriptImpl)this.sectionFactory).setSectionsRefreshAfter(20);
        }
        expectedSections.put("", Arrays.asList("blog", "contact", "news", "publications"));
        expectedSections.put("/news", Arrays.asList("companies", "global", "markets"));
        expectedSections.put("/blog", Arrays.asList(new String[0]));
        expectedSections.put("/contact", Arrays.asList(new String[0]));
        expectedSections.put("/publications", Arrays.asList("research-reports", "white-papers"));
        expectedSections.put("/news/companies", Arrays.asList(new String[0]));
        expectedSections.put("/news/global", Arrays.asList(new String[0]));
        expectedSections.put("/news/markets", Arrays.asList(new String[0]));
        expectedSections.put("/publications/research-reports", Arrays.asList(new String[0]));
        expectedSections.put("/publications/white-papers", Arrays.asList(new String[0]));
        final List<Thread> threads = Collections.synchronizedList(new ArrayList());
        final List errorThreads = Collections.synchronizedList(new ArrayList());
        Runnable treeWalker = new Runnable(){

            @Override
            public void run() {
                try {
                    long timeToStop = System.currentTimeMillis() + 300000L;
                    while (timeToStop > System.currentTimeMillis()) {
                        Section section = site.getRootSection();
                        this.checkSection("", section);
                    }
                }
                catch (AssertionFailedError e) {
                    errorThreads.add(Thread.currentThread());
                    throw e;
                }
                finally {
                    threads.remove(Thread.currentThread());
                }
            }

            private void checkSection(String path, Section section) {
                List children = section.getSections();
                ArrayList<String> childNames = new ArrayList<String>(children.size());
                for (Section child : children) {
                    childNames.add(child.getName());
                }
                List expectedChildren = (List)expectedSections.get(path);
                TestCase.assertNotNull((String)path, (Object)expectedChildren);
                TestCase.assertEquals((String)path, (int)expectedChildren.size(), (int)childNames.size());
                childNames.removeAll(expectedChildren);
                TestCase.assertEquals((String)path, (int)0, (int)childNames.size());
                for (Section child : children) {
                    this.checkSection(path + "/" + child.getName(), child);
                }
            }
        };
        for (int i = 0; i < 30; ++i) {
            Thread thread = new Thread(treeWalker);
            threads.add(thread);
            thread.start();
        }
        System.out.print("Working");
        while (!threads.isEmpty()) {
            if (!errorThreads.isEmpty()) {
                SectionFactoryTest.fail((String)"At least one thread has failed");
            }
            System.out.print(".");
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        System.out.println();
        System.out.println("Finished");
    }
}

