/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.wcm.client.impl;

import java.io.InputStream;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Stack;
import java.util.TreeMap;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.alfresco.wcm.client.impl.ContentInfo;
import org.alfresco.wcm.client.impl.WebscriptResponseHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class AssetDeserializerXmlImpl
extends DefaultHandler
implements WebscriptResponseHandler {
    private static ThreadLocal<DateFormat> dateFormat = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            return new SimpleDateFormat("yyyyMMdd-HH:mm:ss.SSSZ");
        }
    };
    private LinkedList<TreeMap<String, Serializable>> assets;
    private TreeMap<String, Serializable> assetProperties;
    private TreeMap<String, Serializable> headerProperties;
    private Stack<State> previousStates;
    private Stack<String> previousPropertyNames;
    private Stack<TreeMap<String, Serializable>> previousPropertyMaps;
    private State currentState;
    private StringBuilder stringBuilder;
    private String propertyName;
    private ArrayList<Serializable> valueList;
    private ValueType valueType;
    private Serializable value;

    public void reset() {
        this.assets = new LinkedList();
        this.headerProperties = new TreeMap();
        this.assetProperties = null;
        this.previousStates = new Stack();
        this.previousPropertyMaps = new Stack();
        this.previousPropertyNames = new Stack();
        this.currentState = State.not_started;
        this.stringBuilder = null;
        this.propertyName = null;
        this.valueList = null;
        this.value = null;
    }

    public LinkedList<TreeMap<String, Serializable>> deserialize(InputStream in) {
        try {
            this.reset();
            SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
            SAXParser parser = saxParserFactory.newSAXParser();
            parser.parse(in, (DefaultHandler)this);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.assets;
    }

    @Override
    public void handleResponse(InputStream in) {
        this.deserialize(in);
    }

    public LinkedList<TreeMap<String, Serializable>> getAssets() {
        return this.assets;
    }

    public TreeMap<String, Serializable> getHeader() {
        return this.headerProperties;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.stringBuilder != null) {
            this.stringBuilder.append(ch, start, length);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (!qName.equals(this.currentState.toString())) {
            this.invalidElement(qName);
        } else {
            switch (this.currentState) {
                case value: {
                    this.createValueObject();
                    State previousState = this.previousStates.peek();
                    if (previousState != State.list) break;
                    this.valueList.add(this.value);
                    break;
                }
                case list: {
                    this.value = this.valueList;
                    break;
                }
                case map: {
                    this.propertyName = this.previousPropertyNames.pop();
                    this.value = this.assetProperties;
                    this.assetProperties = this.previousPropertyMaps.pop();
                    break;
                }
                case property: {
                    this.assetProperties.put(this.propertyName, this.value);
                    break;
                }
                case asset: {
                    this.assets.add(this.assetProperties);
                    break;
                }
                case header: {
                    this.headerProperties = this.assetProperties;
                    break;
                }
            }
            this.currentState = this.previousStates.pop();
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        switch (this.currentState) {
            case not_started: {
                if (!"assets".equals(qName)) break;
                this.previousStates.push(this.currentState);
                this.currentState = State.assets;
                break;
            }
            case assets: {
                if ("asset".equals(qName)) {
                    this.assetProperties = new TreeMap();
                    this.assetProperties.put("id", (Serializable)((Object)attributes.getValue("id")));
                    this.assetProperties.put("type", (Serializable)((Object)attributes.getValue("type")));
                    this.previousStates.push(this.currentState);
                    this.currentState = State.asset;
                    break;
                }
                if (!"header".equals(qName)) break;
                this.assetProperties = new TreeMap();
                this.previousStates.push(this.currentState);
                this.currentState = State.header;
                break;
            }
            case asset: 
            case header: {
                if (!"property".equals(qName)) break;
                this.propertyName = attributes.getValue("name");
                this.previousStates.push(this.currentState);
                this.currentState = State.property;
                break;
            }
            case property: {
                if ("value".equals(qName)) {
                    this.valueType = ValueType.valueOf(attributes.getValue("type"));
                    this.value = null;
                    this.stringBuilder = new StringBuilder();
                    this.previousStates.push(this.currentState);
                    this.currentState = State.value;
                    break;
                }
                if ("list".equals(qName)) {
                    this.valueList = new ArrayList();
                    this.previousStates.push(this.currentState);
                    this.currentState = State.list;
                    break;
                }
                if (!"map".equals(qName)) break;
                this.previousPropertyMaps.push(this.assetProperties);
                this.assetProperties = new TreeMap();
                this.previousPropertyNames.push(this.propertyName);
                this.previousStates.push(this.currentState);
                this.currentState = State.map;
                break;
            }
            case value: {
                if (!"content".equals(qName)) break;
                ContentInfo info = new ContentInfo();
                info.setMimeType(attributes.getValue("mime"));
                info.setEncoding(attributes.getValue("enc"));
                info.setSize(Long.parseLong(attributes.getValue("size")));
                this.value = info;
                this.previousStates.push(this.currentState);
                this.currentState = State.content;
                break;
            }
            case list: {
                if (!"value".equals(qName)) break;
                this.valueType = ValueType.valueOf(attributes.getValue("type"));
                this.value = null;
                this.stringBuilder = new StringBuilder();
                this.previousStates.push(this.currentState);
                this.currentState = State.value;
                break;
            }
            case map: {
                if (!"property".equals(qName)) break;
                this.propertyName = attributes.getValue("name");
                this.previousStates.push(this.currentState);
                this.currentState = State.property;
                break;
            }
            default: {
                this.invalidElement(qName);
            }
        }
    }

    private void invalidElement(String qName) throws SAXException {
        String msg = "Unexpected element \"" + qName + "\" received. Current state is \"" + String.valueOf((Object)this.currentState) + "\". Previous states are: " + String.valueOf(this.previousStates);
        throw new SAXException(msg);
    }

    private void createValueObject() {
        if (this.value == null) {
            String valueText = this.stringBuilder.toString();
            switch (this.valueType) {
                case bool: {
                    this.value = Boolean.valueOf(valueText);
                    break;
                }
                case id: 
                case text: {
                    this.value = valueText;
                    break;
                }
                case time: {
                    try {
                        this.value = dateFormat.get().parse(valueText);
                    }
                    catch (ParseException parseException) {}
                    break;
                }
                case integer: {
                    this.value = Long.valueOf(valueText);
                    break;
                }
                case number: {
                    this.value = Double.valueOf(valueText);
                    break;
                }
            }
        }
    }

    private static enum State {
        not_started,
        header,
        assets,
        asset,
        property,
        list,
        map,
        value,
        content;

    }

    private static enum ValueType {
        id,
        text,
        integer,
        number,
        bool,
        time,
        content,
        missing;

    }
}

