/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.wcm.client.impl;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeMap;
import org.alfresco.wcm.client.Asset;
import org.alfresco.wcm.client.AssetCollection;
import org.alfresco.wcm.client.AssetCollectionFactory;
import org.alfresco.wcm.client.AssetFactory;
import org.alfresco.wcm.client.Query;
import org.alfresco.wcm.client.impl.AssetCollectionImpl;
import org.alfresco.wcm.client.impl.AssetDeserializerXmlImpl;
import org.alfresco.wcm.client.impl.WebScriptCaller;
import org.alfresco.wcm.client.impl.WebscriptParam;
import org.alfresco.wcm.client.impl.WebscriptResponseHandler;

public class CollectionFactoryWebserviceImpl
implements AssetCollectionFactory {
    private AssetFactory assetFactory;
    private WebScriptCaller webscriptCaller;
    private ThreadLocal<List<WebscriptParam>> localParamList = new ThreadLocal<List<WebscriptParam>>(){

        @Override
        protected List<WebscriptParam> initialValue() {
            return new ArrayList<WebscriptParam>();
        }

        @Override
        public List<WebscriptParam> get() {
            List list = (List)super.get();
            list.clear();
            return list;
        }
    };

    @Override
    public AssetCollection getCollection(String sectionId, String collectionName) {
        return this.getCollection(sectionId, collectionName, 0, -1);
    }

    @Override
    public AssetCollection getCollection(String sectionId, String collectionName, int resultsToSkip, int maxResults) {
        if (sectionId == null || sectionId.length() == 0) {
            throw new IllegalArgumentException("sectionId must be supplied");
        }
        if (collectionName == null || collectionName.length() == 0) {
            throw new IllegalArgumentException("collectionName must be supplied");
        }
        try {
            String scriptUri = "assetcollections/" + URLEncoder.encode(collectionName, "UTF-8");
            WebscriptParam[] params = new WebscriptParam[]{new WebscriptParam("sectionid", sectionId)};
            AssetDeserializerXmlImpl deserializer = new AssetDeserializerXmlImpl();
            this.webscriptCaller.get(scriptUri, (WebscriptResponseHandler)deserializer, params);
            LinkedList<TreeMap<String, Serializable>> assetCollectionList = deserializer.getAssets();
            AssetCollectionImpl collection = null;
            if (assetCollectionList != null && !assetCollectionList.isEmpty()) {
                TreeMap<String, Serializable> assetCollectionData = assetCollectionList.get(0);
                collection = this.buildCollection(sectionId, assetCollectionData);
                List<String> assetIds = collection.getAssetIds();
                Query query = new Query();
                query.setSectionId(sectionId);
                query.setMaxResults(maxResults);
                query.setResultsToSkip(resultsToSkip);
                collection.setQuery(query);
                if (assetIds.size() > 0) {
                    if (maxResults != -1) {
                        int end = resultsToSkip + maxResults;
                        assetIds = assetIds.subList(resultsToSkip, end > assetIds.size() ? assetIds.size() : end);
                    }
                    List<Asset> assets = this.assetFactory.getAssetsById(assetIds);
                    collection.setAssets(assets);
                }
            }
            return collection;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Error encoding URL", e);
        }
    }

    @Override
    public Date getModifiedTimeOfAssetCollection(String assetCollectionId) {
        Date result = null;
        List<WebscriptParam> paramList = this.localParamList.get();
        paramList.add(new WebscriptParam("assetcollectionid", assetCollectionId));
        paramList.add(new WebscriptParam("modifiedTimeOnly", "true"));
        String scriptUri = "assetcollections";
        AssetDeserializerXmlImpl deserializer = new AssetDeserializerXmlImpl();
        this.webscriptCaller.get(scriptUri, (WebscriptResponseHandler)deserializer, paramList);
        LinkedList<TreeMap<String, Serializable>> assetCollectionList = deserializer.getAssets();
        if (!assetCollectionList.isEmpty()) {
            TreeMap<String, Serializable> assetCollectionData = assetCollectionList.get(0);
            result = (Date)assetCollectionData.get("cm:modified");
        }
        return result;
    }

    protected AssetCollectionImpl buildCollection(String sectionId, TreeMap<String, Serializable> assetCollectionData) {
        AssetCollectionImpl collection = new AssetCollectionImpl();
        collection.setProperties(assetCollectionData);
        collection.setPrimarySectionId(sectionId);
        return collection;
    }

    public void setAssetFactory(AssetFactory assetFactory) {
        this.assetFactory = assetFactory;
    }

    public void setWebscriptCaller(WebScriptCaller webscriptCaller) {
        this.webscriptCaller = webscriptCaller;
    }
}

