/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.wcm.client.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.alfresco.wcm.client.Asset;
import org.alfresco.wcm.client.AssetFactory;
import org.alfresco.wcm.client.ContentStream;
import org.alfresco.wcm.client.Query;
import org.alfresco.wcm.client.Rendition;
import org.alfresco.wcm.client.SearchResults;
import org.alfresco.wcm.client.WebSite;
import org.alfresco.wcm.client.WebSiteService;
import org.alfresco.wcm.client.impl.AssetImpl;
import org.alfresco.wcm.client.impl.CachingContentStreamImpl;
import org.alfresco.wcm.client.impl.CachingRenditionImpl;
import org.alfresco.wcm.client.impl.cache.SimpleCache;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CachingAssetFactoryImpl
implements AssetFactory {
    private static final Log log = LogFactory.getLog(CachingAssetFactoryImpl.class);
    private AssetFactory delegate;
    private SimpleCache<String, CacheEntry> cache;
    private long minimumCacheMilliseconds = 30000L;
    private boolean cacheContent = true;
    private boolean cacheRelationships = true;

    public void setDelegate(AssetFactory delegate) {
        this.delegate = delegate;
    }

    public void setCache(SimpleCache<String, CacheEntry> newCache) {
        this.cache = newCache;
    }

    public void setMinimumCacheSeconds(int seconds) {
        this.minimumCacheMilliseconds = (long)seconds * 1000L;
    }

    public void setCacheContent(boolean cacheContent) {
        this.cacheContent = cacheContent;
    }

    public void setCacheRelationships(boolean cacheRelationships) {
        this.cacheRelationships = cacheRelationships;
    }

    @Override
    public SearchResults findByQuery(Query query) {
        return this.delegate.findByQuery(query);
    }

    @Override
    public Asset getAssetById(String id, boolean deferredLoad) {
        CacheEntry cacheEntry = this.loadCacheEntry(id, deferredLoad);
        return cacheEntry.asset;
    }

    private CacheEntry loadCacheEntry(String id, boolean deferredLoad) {
        CacheEntry cacheEntry = this.getCacheEntry(id);
        if (cacheEntry == null) {
            Asset asset;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Missed cache for asset: " + id));
            }
            if (AssetImpl.class.isAssignableFrom((asset = this.delegate.getAssetById(id, deferredLoad)).getClass())) {
                ((AssetImpl)asset).setAssetFactory(this);
            }
            cacheEntry = new CacheEntry(asset);
            this.cache.put(id, cacheEntry);
        }
        return cacheEntry;
    }

    private CacheEntry getCacheEntry(String id) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Checking cache for asset: " + id));
        }
        long now = System.currentTimeMillis();
        long refreshCutoffTime = now - this.getMinimumCacheMilliseconds();
        CacheEntry cacheEntry = this.cache.get(id);
        if (cacheEntry != null && cacheEntry.cacheTime < refreshCutoffTime) {
            Date cachedModifiedTime;
            Asset asset = cacheEntry.asset;
            Date currentModifiedTime = this.delegate.getModifiedTimeOfAsset(id);
            if (currentModifiedTime.after(cachedModifiedTime = (Date)asset.getProperty("cmis:lastModificationDate"))) {
                this.cache.remove(id);
                cacheEntry = null;
            } else {
                cacheEntry.cacheTime = now;
            }
        }
        return cacheEntry;
    }

    @Override
    public Asset getAssetById(String id) {
        return this.getAssetById(id, false);
    }

    @Override
    public List<Asset> getAssetsById(Collection<String> ids, boolean deferredLoad) {
        ArrayList<String> idsToLoad = new ArrayList<String>(ids.size());
        TreeMap<String, Asset> assetsToCheck = new TreeMap<String, Asset>();
        TreeMap<String, Asset> foundAssets = new TreeMap<String, Asset>();
        long now = System.currentTimeMillis();
        long refreshCutoffTime = now - this.getMinimumCacheMilliseconds();
        for (String id : ids) {
            CacheEntry cacheEntry = this.cache.get(id);
            if (cacheEntry != null) {
                if (cacheEntry.cacheTime < refreshCutoffTime) {
                    assetsToCheck.put(id, cacheEntry.asset);
                    continue;
                }
                foundAssets.put(id, cacheEntry.asset);
                continue;
            }
            idsToLoad.add(id);
        }
        if (!assetsToCheck.isEmpty()) {
            Map<String, Date> currentModifiedTimes = this.delegate.getModifiedTimesOfAssets(assetsToCheck.keySet());
            for (Map.Entry entry : currentModifiedTimes.entrySet()) {
                Date cachedModifiedTime;
                String assetId = (String)entry.getKey();
                Asset cachedAsset = (Asset)assetsToCheck.get(assetId);
                Date currentModifiedTime = (Date)entry.getValue();
                if (currentModifiedTime.after(cachedModifiedTime = (Date)cachedAsset.getProperty("cmis:lastModificationDate"))) {
                    this.cache.remove(assetId);
                    idsToLoad.add(assetId);
                    continue;
                }
                foundAssets.put(assetId, cachedAsset);
                CacheEntry cachedEntry = this.cache.get(assetId);
                if (cachedEntry == null) continue;
                cachedEntry.cacheTime = now;
            }
        }
        if (!idsToLoad.isEmpty()) {
            List<Asset> assets = this.delegate.getAssetsById(idsToLoad, deferredLoad);
            for (Asset asset : assets) {
                if (AssetImpl.class.isAssignableFrom(asset.getClass())) {
                    ((AssetImpl)asset).setAssetFactory(this);
                }
                foundAssets.put(asset.getId(), asset);
                this.cache.put(asset.getId(), new CacheEntry(asset));
            }
        }
        ArrayList<Asset> finalResults = new ArrayList<Asset>(foundAssets.size());
        for (String string : ids) {
            Asset asset = (Asset)foundAssets.get(string);
            if (asset == null) continue;
            finalResults.add(asset);
        }
        return finalResults;
    }

    @Override
    public List<Asset> getAssetsById(Collection<String> ids) {
        return this.getAssetsById(ids, false);
    }

    @Override
    public Date getModifiedTimeOfAsset(String assetId) {
        return this.delegate.getModifiedTimeOfAsset(assetId);
    }

    @Override
    public Map<String, Date> getModifiedTimesOfAssets(Collection<String> assetIds) {
        return this.delegate.getModifiedTimesOfAssets(assetIds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Rendition> getRenditions(String assetId) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Checking cache for renditions: " + assetId));
        }
        CacheEntry cacheEntry = this.loadCacheEntry(assetId, false);
        if (cacheEntry.renditions == null) {
            Object object = cacheEntry.mutex;
            synchronized (object) {
                if (cacheEntry.renditions == null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Missed cache for renditions: " + assetId));
                    }
                    Map<String, CachingRenditionImpl> returnRenditions = new TreeMap();
                    Map<String, Rendition> sourceRenditions = this.delegate.getRenditions(assetId);
                    for (Map.Entry<String, Rendition> entry : sourceRenditions.entrySet()) {
                        try {
                            returnRenditions.put(entry.getKey(), new CachingRenditionImpl(entry.getValue()));
                        }
                        catch (IOException iOException) {}
                    }
                    returnRenditions = Collections.unmodifiableMap(returnRenditions);
                    cacheEntry.renditions = returnRenditions;
                }
            }
        }
        return cacheEntry.renditions;
    }

    @Override
    public Asset getSectionAsset(String sectionId, String assetName, boolean wildcardsAllowedInName) {
        return this.delegate.getSectionAsset(sectionId, assetName, wildcardsAllowedInName);
    }

    @Override
    public Asset getSectionAsset(String sectionId, String assetName) {
        return this.delegate.getSectionAsset(sectionId, assetName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, List<String>> getSourceRelationships(String assetId) {
        Map<String, List<String>> results;
        if (this.cacheRelationships) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Checking cache for source relationships: " + assetId));
            }
            CacheEntry cacheEntry = this.loadCacheEntry(assetId, false);
            if (cacheEntry.sourceRelationships == null) {
                Object object = cacheEntry.mutex;
                synchronized (object) {
                    if (cacheEntry.sourceRelationships == null) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Missed cache for source relationships: " + assetId));
                        }
                        cacheEntry.sourceRelationships = this.delegate.getSourceRelationships(assetId);
                    }
                }
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("Hit cache for source relationships: " + assetId));
            }
            results = cacheEntry.sourceRelationships;
        } else {
            results = this.delegate.getSourceRelationships(assetId);
        }
        return results;
    }

    private long getMinimumCacheMilliseconds() {
        long result = 0L;
        WebSite currentSite = WebSiteService.getThreadWebSite();
        if (currentSite == null || !currentSite.isEditorialSite()) {
            result = this.minimumCacheMilliseconds;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ContentStream getContentStream(String assetId) {
        ContentStream contentStream = null;
        if (this.cacheContent) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Checking cache for content stream: " + assetId));
            }
            CacheEntry cacheEntry = this.loadCacheEntry(assetId, false);
            if (cacheEntry.contentStream == null) {
                Object object = cacheEntry.mutex;
                synchronized (object) {
                    if (cacheEntry.contentStream == null) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Missed cache for content stream: " + assetId));
                        }
                        contentStream = this.delegate.getContentStream(assetId);
                        try {
                            cacheEntry.contentStream = new CachingContentStreamImpl(contentStream);
                            contentStream = cacheEntry.contentStream;
                        }
                        catch (Exception ex) {
                            log.warn((Object)("Failed to create cached content stream for asset " + assetId), (Throwable)ex);
                        }
                    }
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Hit cache for content stream: " + assetId));
            }
            contentStream = cacheEntry.contentStream;
        } else {
            contentStream = this.delegate.getContentStream(assetId);
        }
        return contentStream;
    }

    private static class CacheEntry {
        public long cacheTime;
        public final Asset asset;
        public volatile CachingContentStreamImpl contentStream;
        public volatile Map<String, Rendition> renditions;
        public volatile Map<String, List<String>> sourceRelationships;
        public final Object mutex = new Object();

        public CacheEntry(Asset asset) {
            this.asset = asset;
            this.cacheTime = System.currentTimeMillis();
        }
    }
}

