/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.wcm.client.impl;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.alfresco.wcm.client.Asset;
import org.alfresco.wcm.client.AssetFactory;

public class DeferredLoadingAssetListImpl
implements List<Asset> {
    private AssetFactory assetFactory;
    private Collection<String> assetIds;
    private List<Asset> delegate;

    public DeferredLoadingAssetListImpl(Collection<String> assetIds, AssetFactory assetFactory) {
        this.assetIds = assetIds;
        this.assetFactory = assetFactory;
    }

    @Override
    public boolean add(Asset e) {
        return this.getDelegate().add(e);
    }

    @Override
    public void add(int index, Asset element) {
        this.getDelegate().add(index, element);
    }

    @Override
    public boolean addAll(Collection<? extends Asset> c) {
        return this.getDelegate().addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends Asset> c) {
        return this.getDelegate().addAll(index, c);
    }

    @Override
    public void clear() {
        this.assetIds.clear();
        if (this.delegate != null) {
            this.delegate.clear();
        }
    }

    @Override
    public boolean contains(Object o) {
        return this.getDelegate().contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.getDelegate().containsAll(c);
    }

    @Override
    public boolean equals(Object o) {
        return this.getDelegate().equals(o);
    }

    @Override
    public Asset get(int index) {
        return this.getDelegate().get(index);
    }

    @Override
    public int hashCode() {
        return this.getDelegate().hashCode();
    }

    @Override
    public int indexOf(Object o) {
        return this.getDelegate().indexOf(o);
    }

    @Override
    public boolean isEmpty() {
        return this.assetIds.isEmpty();
    }

    @Override
    public Iterator<Asset> iterator() {
        return this.getDelegate().iterator();
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.getDelegate().lastIndexOf(o);
    }

    @Override
    public ListIterator<Asset> listIterator() {
        return this.getDelegate().listIterator();
    }

    @Override
    public ListIterator<Asset> listIterator(int index) {
        return this.getDelegate().listIterator(index);
    }

    @Override
    public Asset remove(int index) {
        return this.getDelegate().remove(index);
    }

    @Override
    public boolean remove(Object o) {
        return this.getDelegate().remove(o);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.getDelegate().removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.getDelegate().retainAll(c);
    }

    @Override
    public Asset set(int index, Asset element) {
        return this.getDelegate().set(index, element);
    }

    @Override
    public int size() {
        return this.assetIds.size();
    }

    @Override
    public List<Asset> subList(int fromIndex, int toIndex) {
        return this.getDelegate().subList(fromIndex, toIndex);
    }

    @Override
    public Object[] toArray() {
        return this.getDelegate().toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.getDelegate().toArray(a);
    }

    private List<Asset> getDelegate() {
        if (this.delegate == null) {
            this.delegate = this.assetFactory.getAssetsById(this.assetIds, false);
        }
        return this.delegate;
    }
}

