/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.wcm.client.directive;

import freemarker.core.Environment;
import freemarker.template.TemplateDirectiveBody;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.alfresco.wcm.client.directive.AbstractTemplateDirective;
import org.alfresco.web.awe.tag.AlfrescoTagUtil;
import org.alfresco.web.awe.tag.MarkedContent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WebEditorEndTemplateDirective
extends AbstractTemplateDirective {
    protected static final Log logger = LogFactory.getLog(WebEditorEndTemplateDirective.class);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute(Environment env, Map params, TemplateModel[] loopVars, TemplateDirectiveBody body) throws TemplateException, IOException {
        if (params.size() > 0) {
            throw new TemplateModelException("endTemplate directive expects no parameters");
        }
        String toolbarLocation = this.getToolbarLocation(env);
        if (this.isEditingEnabled(env) && toolbarLocation != null) {
            try {
                Writer out = env.getOut();
                HttpServletRequest request = this.getRequest(env);
                out.write("<script type=\"text/javascript\">\n");
                out.write("WEF.ConfigRegistry.registerConfig('org.springframework.extensions.webeditor.ui.ribbon',\n");
                out.write("{ position: \"");
                out.write(toolbarLocation);
                out.write("\" });");
                List markedContent = AlfrescoTagUtil.getMarkedContent((ServletRequest)request);
                out.write("\nvar urlParts = window.location.href.split(\"/\");");
                out.write("\nvar categoryRootUrl =  urlParts[0] + \"//\";");
                out.write("\nfor (var i=2; i < urlParts.length - 1; i++)");
                out.write("\n{");
                out.write("\n   categoryRootUrl += urlParts[i] + \"/\";");
                out.write("\n}");
                out.write("\ncategoryRootUrl += \"index.html\";");
                out.write("\nWEF.ConfigRegistry.registerConfig('org.alfresco.awe',{id:'awe',name:'awe',editables:[\n");
                boolean first = true;
                for (MarkedContent content : markedContent) {
                    if (!first) {
                        out.write(",");
                    } else {
                        first = false;
                    }
                    out.write("\n{\n   id: \"");
                    out.write(this.encode(content.getMarkerId()));
                    out.write("\",\n   nodeRef: \"");
                    out.write(this.encode(content.getContentId()));
                    out.write("\",\n   title: \"");
                    out.write(this.encode(content.getContentTitle()));
                    out.write("\",\n   nested: ");
                    out.write(Boolean.toString(content.isNested()));
                    out.write(",\n   redirectUrl: categoryRootUrl");
                    if (content.getFormId() != null) {
                        out.write(",\n   formId: \"");
                        out.write(this.encode(content.getFormId()));
                        out.write("\"");
                    }
                    out.write("\n}");
                }
                out.write("]});\n");
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Completed endTemplate rendering for " + markedContent.size() + " marked content items with toolbar location of: " + this.getToolbarLocation(env)));
                }
                out.write("\n</script>");
                out.write("<script type=\"text/javascript\" src=\"");
                out.write(this.getWebEditorUrlPrefix(env));
                out.write("/service/wef/resources\"></script>\n");
                if (!logger.isDebugEnabled()) return;
                logger.debug((Object)"Completed endTemplate rendering");
                return;
            }
            catch (IOException ioe) {
                throw new TemplateModelException(ioe.toString());
            }
        } else {
            if (!logger.isDebugEnabled()) return;
            logger.debug((Object)"Skipping endTemplate rendering as editing is disabled");
        }
    }
}

