/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.wcm.client.directive;

import freemarker.core.Environment;
import freemarker.template.SimpleScalar;
import freemarker.template.TemplateDirectiveBody;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.alfresco.wcm.client.directive.AbstractTemplateDirective;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WebEditorStartTemplateDirective
extends AbstractTemplateDirective {
    protected static final Log logger = LogFactory.getLog(WebEditorStartTemplateDirective.class);
    private static final String ALF = "alf_";

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute(Environment env, Map params, TemplateModel[] loopVars, TemplateDirectiveBody body) throws TemplateException, IOException {
        if (params.size() > 1) {
            throw new TemplateModelException("truncate directive expects no more than one parameter");
        }
        SimpleScalar locationParam = (SimpleScalar)params.get("toolbarLocation");
        String toolbarLocation = "top";
        if (locationParam != null) {
            String location = locationParam.getAsString();
            if (location.equalsIgnoreCase("top")) {
                toolbarLocation = "top";
            } else if (location.equalsIgnoreCase("left")) {
                toolbarLocation = "left";
            } else if (location.equalsIgnoreCase("right")) {
                toolbarLocation = "right";
            }
        }
        if (this.isEditingEnabled(env)) {
            HttpServletRequest request = this.getRequest(env);
            request.setAttribute("wef_toolbar_location", (Object)toolbarLocation);
            try {
                Writer out = env.getOut();
                out.write("<script type=\"text/javascript\" src=\"");
                out.write(this.getWebEditorUrlPrefix(env));
                out.write("/service/wef/bootstrap");
                if (this.isDebugEnabled(env)) {
                    out.write("?debug=true");
                }
                request.setAttribute("awe_marker_id_prefix", (Object)(ALF + System.currentTimeMillis()));
                out.write("\"></script>\n");
                if (!logger.isDebugEnabled()) return;
                logger.debug((Object)"Completed startTemplate rendering");
                return;
            }
            catch (IOException ioe) {
                throw new TemplateModelException(ioe.toString());
            }
        } else {
            if (!logger.isDebugEnabled()) return;
            logger.debug((Object)"Skipping startTemplate rendering as editing is disabled");
        }
    }
}

