/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.wcm.client.interceptor;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Locale;
import java.util.Set;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.alfresco.wcm.client.PathResolutionDetails;
import org.alfresco.wcm.client.Section;
import org.alfresco.wcm.client.WebSite;
import org.alfresco.wcm.client.WebSiteService;
import org.alfresco.wcm.client.exception.PageNotFoundException;
import org.alfresco.wcm.client.interceptor.ModelDecorator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.RequestContext;
import org.springframework.extensions.surf.support.ThreadLocalRequestContext;
import org.springframework.extensions.surf.util.I18NUtil;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class ApplicationDataInterceptor
extends HandlerInterceptorAdapter {
    private static final Log log = LogFactory.getLog(ApplicationDataInterceptor.class);
    private WebSiteService webSiteService;
    private ModelDecorator modelDecorator;
    private Set<String> countryCodes = new TreeSet();
    private Set<String> languageCodes = new TreeSet();

    public void init() {
        this.countryCodes.addAll(Arrays.asList(Locale.getISOCountries()));
        this.languageCodes.addAll(Arrays.asList(Locale.getISOLanguages()));
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        String contextPath;
        int serverPort;
        RequestContext requestContext = ThreadLocalRequestContext.getRequestContext();
        String serverName = request.getServerName();
        WebSite webSite = this.webSiteService.getWebSite(serverName, serverPort = request.getServerPort(), contextPath = request.getContextPath());
        if (webSite == null) {
            log.warn((Object)("Received request for which no configured website can be found: " + serverName + ":" + serverPort));
            throw new PageNotFoundException(serverName + ":" + serverPort);
        }
        WebSiteService.setThreadWebSite((WebSite)webSite);
        requestContext.setValue("webSite", (Serializable)webSite);
        requestContext.setValue("website", (Serializable)webSite);
        String path = request.getPathInfo();
        PathResolutionDetails resolvedPath = webSite.resolvePath(path);
        if (resolvedPath.isRedirect()) {
            Object location = resolvedPath.getRedirectLocation();
            if (((String)location).startsWith("/")) {
                location = contextPath + (String)location;
            }
            response.sendRedirect((String)location);
            return false;
        }
        requestContext.setValue("asset", (Serializable)resolvedPath.getAsset());
        Section section = resolvedPath.getSection();
        if (section == null) {
            section = webSite.getRootSection();
        }
        requestContext.setValue("section", (Serializable)section);
        this.setLocaleFromPath(requestContext, path);
        return super.preHandle(request, response, handler);
    }

    protected void setLocaleFromPath(RequestContext requestContext, String path) {
        WebSite webSite = (WebSite)requestContext.getValue("webSite");
        Section rootSection = webSite.getRootSection();
        int pathlength = path.length();
        if (pathlength > 1) {
            String topLevelPath;
            String[] pathElements = path.split("/");
            if (log.isDebugEnabled()) {
                log.debug((Object)("RootNavInterceptor: " + pathElements.length + " : " + path));
            }
            if ((topLevelPath = pathElements[1]).length() == 2 && this.languageCodes.contains(topLevelPath)) {
                rootSection = rootSection.getSection(topLevelPath);
                String language = topLevelPath;
                Locale locale = null;
                locale = I18NUtil.parseLocale((String)language);
                I18NUtil.setLocale((Locale)locale);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Picked " + String.valueOf(I18NUtil.getLocale()) + " from " + topLevelPath));
                }
                requestContext.setValue("locale", (Serializable)locale);
            }
        }
        requestContext.setValue("rootSection", (Serializable)rootSection);
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
        super.postHandle(request, response, handler, modelAndView);
        this.modelDecorator.populate(request, modelAndView);
    }

    public void setWebSiteService(WebSiteService webSiteService) {
        this.webSiteService = webSiteService;
    }

    public void setModelDecorator(ModelDecorator modelDecorator) {
        this.modelDecorator = modelDecorator;
    }
}

