/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.wcm.client.interceptor;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.alfresco.wcm.client.util.CmisSessionHelper;
import org.alfresco.wcm.client.util.CmisSessionPool;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class CmisSessionInterceptor
extends HandlerInterceptorAdapter {
    private static final Log log = LogFactory.getLog(CmisSessionInterceptor.class);
    private CmisSessionPool sessionPool;
    private static ThreadLocal<Long> timings = new /* Unavailable Anonymous Inner Class!! */;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (log.isDebugEnabled()) {
            timings.set(System.currentTimeMillis());
        }
        Session session = this.sessionPool.getGuestSession();
        CmisSessionHelper.setSession((Session)session);
        return super.preHandle(request, response, handler);
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        super.afterCompletion(request, response, handler, ex);
        Session session = CmisSessionHelper.getSession();
        this.sessionPool.closeSession(session);
        if (log.isDebugEnabled()) {
            long start = (Long)timings.get();
            timings.remove();
            long end = System.currentTimeMillis();
            log.debug((Object)("*** " + request.getPathInfo() + " " + (end - start) + "ms"));
        }
    }

    public void setSessionPool(CmisSessionPool sessionPool) {
        this.sessionPool = sessionPool;
    }
}

