/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.wcm.client.webscript;

import com.sun.syndication.feed.synd.SyndContent;
import com.sun.syndication.feed.synd.SyndContentImpl;
import com.sun.syndication.feed.synd.SyndEntryImpl;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.feed.synd.SyndFeedImpl;
import com.sun.syndication.io.FeedException;
import com.sun.syndication.io.SyndFeedOutput;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Date;
import org.alfresco.wcm.client.Asset;
import org.alfresco.wcm.client.AssetCollection;
import org.alfresco.wcm.client.CollectionFactory;
import org.alfresco.wcm.client.Section;
import org.alfresco.wcm.client.WebSite;
import org.alfresco.wcm.client.util.UrlUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.RequestContext;
import org.springframework.extensions.surf.support.ThreadLocalRequestContext;
import org.springframework.extensions.webscripts.AbstractWebScript;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;
import org.springframework.extensions.webscripts.WebScriptResponse;

public class RssWebScript
extends AbstractWebScript {
    private static final String FEED_TYPE = "rss_2.0";
    private static final Log log = LogFactory.getLog((String)RssWebScript.class.getName());
    private UrlUtils urlUtils;
    private CollectionFactory collectionFactory;

    public void execute(WebScriptRequest req, WebScriptResponse res) throws IOException {
        Writer writer = null;
        try {
            writer = res.getWriter();
            RequestContext requestContext = ThreadLocalRequestContext.getRequestContext();
            Section section = (Section)requestContext.getValue("section");
            WebSite webSite = (WebSite)requestContext.getValue("webSite");
            String collectionName = requestContext.getPage().getProperty("collection");
            if (collectionName == null) {
                throw new WebScriptException("collectionName property must be supplied");
            }
            AssetCollection collection = this.collectionFactory.getCollection(section.getId(), collectionName);
            SyndFeedImpl feed = new SyndFeedImpl();
            feed.setFeedType(FEED_TYPE);
            feed.setTitle(section.getTitle());
            feed.setLink(this.urlUtils.getWebsiteDomain(webSite) + this.urlUtils.getUrl(section));
            feed.setDescription(section.getDescription());
            ArrayList<SyndEntryImpl> entries = new ArrayList<SyndEntryImpl>();
            for (Asset asset : collection.getAssets()) {
                SyndEntryImpl entry = new SyndEntryImpl();
                entry.setTitle(asset.getTitle());
                entry.setLink(this.urlUtils.getWebsiteDomain(webSite) + this.urlUtils.getUrl(asset));
                entry.setUri(this.urlUtils.getWebsiteDomain(webSite) + this.urlUtils.getShortUrl(asset));
                entry.setPublishedDate((Date)asset.getProperties().get("ws:publishedTime"));
                SyndContentImpl description = new SyndContentImpl();
                description.setType("text/html");
                description.setValue(asset.getDescription());
                entry.setDescription((SyndContent)description);
                entries.add(entry);
            }
            feed.setEntries(entries);
            SyndFeedOutput output = new SyndFeedOutput();
            output.output((SyndFeed)feed, writer);
            writer.flush();
        }
        catch (IOException e) {
            log.error((Object)"Unable to output rss", (Throwable)e);
        }
        catch (FeedException e) {
            log.error((Object)"Unable to output rss", (Throwable)e);
        }
    }

    public void setUrlUtils(UrlUtils urlUtils) {
        this.urlUtils = urlUtils;
    }

    public void setCollectionFactory(CollectionFactory collectionFactory) {
        this.collectionFactory = collectionFactory;
    }
}

