/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.wcm.client.controller;

import org.alfresco.wcm.client.AssetFactory;
import org.alfresco.wcm.client.Query;
import org.alfresco.wcm.client.SearchResults;
import org.alfresco.wcm.client.Section;
import org.alfresco.wcm.client.SectionFactory;
import org.alfresco.wcm.client.WebSiteService;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/**/search.html"})
public class SearchFormController {
    private AssetFactory assetFactory;
    private SectionFactory sectionFactory;

    @RequestMapping(method={RequestMethod.GET})
    protected String search(Query query, Model model) {
        if (query.getSectionId() == null) {
            query.setSectionId(WebSiteService.getThreadWebSite().getRootSection().getId());
        }
        SearchResults results = this.assetFactory.findByQuery(query);
        Section section = this.sectionFactory.getSection(query.getSectionId());
        if (section.getContainingSection() != null) {
            model.addAttribute("sectionTitle", (Object)(section.getTitle() != null ? section.getTitle() : section.getName()));
        }
        model.addAttribute("results", (Object)results);
        return "search";
    }

    public void setAssetFactory(AssetFactory assetFactory) {
        this.assetFactory = assetFactory;
    }

    public void setSectionFactory(SectionFactory sectionFactory) {
        this.sectionFactory = sectionFactory;
    }
}

