/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.wcm.client.interceptor;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.alfresco.wcm.client.util.CmisSessionHelper;
import org.alfresco.wcm.client.util.CmisSessionPool;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.web.servlet.HandlerInterceptor;

public class CmisSessionInterceptor
implements HandlerInterceptor {
    private static final Log log = LogFactory.getLog(CmisSessionInterceptor.class);
    private CmisSessionPool sessionPool;
    private static ThreadLocal<Long> timings = new ThreadLocal<Long>(){};

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (log.isDebugEnabled()) {
            timings.set(System.currentTimeMillis());
        }
        Session session = this.sessionPool.getGuestSession();
        CmisSessionHelper.setSession((Session)session);
        return super.preHandle(request, response, handler);
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        super.afterCompletion(request, response, handler, ex);
        Session session = CmisSessionHelper.getSession();
        this.sessionPool.closeSession(session);
        if (log.isDebugEnabled()) {
            long start = timings.get();
            timings.remove();
            long end = System.currentTimeMillis();
            log.debug((Object)("*** " + request.getPathInfo() + " " + (end - start) + "ms"));
        }
    }

    public void setSessionPool(CmisSessionPool sessionPool) {
        this.sessionPool = sessionPool;
    }
}

