/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.wcm.client.viewresolver;

import java.util.Locale;
import org.alfresco.wcm.client.Asset;
import org.alfresco.wcm.client.exception.EditorialException;
import org.alfresco.wcm.client.view.StreamedAssetView;
import org.springframework.extensions.surf.RequestContext;
import org.springframework.extensions.surf.mvc.AbstractWebFrameworkViewResolver;
import org.springframework.extensions.surf.mvc.PageView;
import org.springframework.extensions.surf.support.ThreadLocalRequestContext;
import org.springframework.extensions.surf.types.Page;
import org.springframework.web.servlet.view.AbstractUrlBasedView;

public class DynamicPageViewResolver
extends AbstractWebFrameworkViewResolver {
    public static final String RAW_TEMPLATE_NAME = "raw";

    public DynamicPageViewResolver() {
        this.setCache(false);
    }

    protected boolean canHandle(String viewName, Locale locale) {
        RequestContext requestContext = ThreadLocalRequestContext.getRequestContext();
        Asset asset = (Asset)requestContext.getValue("asset");
        return asset != null;
    }

    protected AbstractUrlBasedView buildView(String viewName) throws Exception {
        StreamedAssetView view = null;
        RequestContext requestContext = ThreadLocalRequestContext.getRequestContext();
        Asset asset = (Asset)requestContext.getValue("asset");
        String template = requestContext.getParameter("view");
        if (template == null) {
            template = asset.getTemplate();
        }
        if (template == null || RAW_TEMPLATE_NAME.equalsIgnoreCase(template)) {
            boolean attach = Boolean.parseBoolean(requestContext.getParameter("attach"));
            view = new StreamedAssetView(asset, attach);
        } else {
            Page page = this.lookupPage(template);
            if (page == null) {
                throw new EditorialException("Invalid template page \"" + template + "\" specified for " + asset.getContainingSection().getPath() + asset.getName(), "template.none", asset.getContainingSection().getPath() + asset.getName() + asset.getName());
            }
            PageView pageView = new PageView(this.getServiceRegistry());
            pageView.setUrl(template);
            pageView.setPage(page);
            view = pageView;
        }
        return view;
    }
}

