/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.wcm.client.directive;

import freemarker.core.Environment;
import freemarker.ext.beans.StringModel;
import freemarker.ext.servlet.HttpRequestHashModel;
import freemarker.template.SimpleScalar;
import freemarker.template.TemplateDirectiveBody;
import freemarker.template.TemplateDirectiveModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.Map;
import java.util.TreeMap;
import org.alfresco.wcm.client.Asset;
import org.alfresco.wcm.client.Section;
import org.alfresco.wcm.client.util.UrlUtils;

public class UrlDirective
implements TemplateDirectiveModel {
    private UrlUtils urlUtils;

    public void execute(Environment env, Map params, TemplateModel[] loopVars, TemplateDirectiveBody body) throws TemplateException, IOException {
        Object url;
        if (params.size() < 1 && params.size() > 2) {
            throw new TemplateModelException("url directive expects one or two parameters");
        }
        StringModel assetParam = (StringModel)params.get("asset");
        StringModel sectionParam = (StringModel)params.get("section");
        if (!(assetParam != null && assetParam.getWrappedObject() instanceof Asset || sectionParam != null && sectionParam.getWrappedObject() instanceof Section)) {
            throw new TemplateModelException("url directive expects asset or section parameter");
        }
        SimpleScalar forceParam = (SimpleScalar)params.get("force");
        String force = null;
        if (forceParam != null) {
            force = forceParam.getAsString();
        }
        String requestUrl = ((HttpRequestHashModel)env.getDataModel().get("Request")).getRequest().getContextPath();
        if (assetParam != null) {
            SimpleScalar renditionParam = (SimpleScalar)params.get("rendition");
            SimpleScalar attachParam = (SimpleScalar)params.get("attach");
            if (renditionParam != null) {
                force = "short";
            }
            Asset asset = (Asset)assetParam.getWrappedObject();
            url = "short".equals(force) ? requestUrl + this.urlUtils.getShortUrl(asset) : ("long".equals(force) ? requestUrl + this.urlUtils.getLongUrl(asset) : requestUrl + this.urlUtils.getUrl(asset));
            TreeMap<String, SimpleScalar> queryParams = new TreeMap<String, SimpleScalar>();
            if (renditionParam != null) {
                queryParams.put("rendition", renditionParam);
            }
            if (attachParam != null) {
                queryParams.put("attach", attachParam);
            }
            url = this.appendQueryParams((String)url, queryParams);
        } else {
            Section section = (Section)sectionParam.getWrappedObject();
            url = requestUrl + this.urlUtils.getUrl(section);
        }
        env.getOut().write((String)url);
    }

    private String appendQueryParams(String url, Map<String, SimpleScalar> queryParams) throws IOException {
        if (queryParams == null || queryParams.isEmpty()) {
            return url;
        }
        StringBuilder sb = new StringBuilder(url);
        boolean first = true;
        for (Map.Entry<String, SimpleScalar> entry : queryParams.entrySet()) {
            if (first) {
                sb.append('?');
            } else {
                sb.append('&');
            }
            sb.append(entry.getKey());
            sb.append('=');
            sb.append(URLEncoder.encode(entry.getValue().getAsString(), "UTF-8"));
            first = false;
        }
        return sb.toString();
    }

    public void setUrlUtils(UrlUtils urlUtils) {
        this.urlUtils = urlUtils;
    }
}

