/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.config.forms;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public enum Mode {
    VIEW,
    EDIT,
    CREATE;

    private static Log logger;

    public String toString() {
        return super.toString().toLowerCase();
    }

    public static Mode modeFromString(String modeString) {
        if ("create".equalsIgnoreCase(modeString)) {
            return CREATE;
        }
        if ("edit".equalsIgnoreCase(modeString)) {
            return EDIT;
        }
        if ("view".equalsIgnoreCase(modeString)) {
            return VIEW;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Illegal modeString: " + modeString));
        }
        return null;
    }

    public static List<Mode> modesFromString(String commaSeparatedModesString) {
        if (commaSeparatedModesString == null) {
            return Collections.emptyList();
        }
        ArrayList<Mode> result = new ArrayList<Mode>();
        StringTokenizer st = new StringTokenizer(commaSeparatedModesString, ",");
        while (st.hasMoreTokens()) {
            String nextToken = st.nextToken().trim();
            Mode nextMode = Mode.modeFromString(nextToken);
            result.add(nextMode);
        }
        return result;
    }

    static {
        logger = LogFactory.getLog(Mode.class);
    }
}

