/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.wcm.client.view;

import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.OutputStream;
import java.util.Map;
import org.alfresco.wcm.client.Asset;
import org.alfresco.wcm.client.ContentStream;
import org.alfresco.wcm.client.util.HeaderHelper;
import org.alfresco.wcm.client.util.impl.SimpleCacheControlHeaderHelper;
import org.springframework.web.servlet.view.AbstractUrlBasedView;

public class StreamedAssetView
extends AbstractUrlBasedView {
    private static HeaderHelper headerHelper = new SimpleCacheControlHeaderHelper();
    private Asset asset;
    private boolean attach;
    private String renditionName;

    public StreamedAssetView(Asset asset, String renditionName, boolean attach) {
        this.asset = asset;
        this.attach = attach;
        this.renditionName = renditionName;
    }

    public StreamedAssetView(Asset asset) {
        this(asset, null, false);
    }

    public StreamedAssetView(Asset asset, String renditionName) {
        this(asset, renditionName, false);
    }

    public StreamedAssetView(Asset asset, boolean attach) {
        this(asset, null, attach);
    }

    protected boolean isUrlRequired() {
        return false;
    }

    public static void setHeaderHelper(HeaderHelper headerHelper) {
        StreamedAssetView.headerHelper = headerHelper;
    }

    protected void renderMergedOutputModel(Map<String, Object> model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        boolean render = headerHelper.setHeaders(this.asset, this.attach, request, response);
        ServletOutputStream out = null;
        if (render) {
            ContentStream contentStream = null;
            if (this.renditionName != null) {
                Map renditions = this.asset.getRenditions();
                contentStream = (ContentStream)renditions.get(this.renditionName);
            } else {
                contentStream = this.asset.getContentAsInputStream();
            }
            if (contentStream != null) {
                String mimeType = contentStream.getMimeType();
                response.setContentType(mimeType == null ? "application/octet-stream" : mimeType);
                response.setContentLength((int)contentStream.getLength());
                out = response.getOutputStream();
                contentStream.output((OutputStream)out);
            }
        }
    }
}

