/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.wcm.client.exceptionresolver;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.alfresco.wcm.client.Asset;
import org.alfresco.wcm.client.Section;
import org.alfresco.wcm.client.exception.PageNotFoundException;
import org.alfresco.wcm.client.exception.RepositoryUnavailableException;
import org.alfresco.wcm.client.interceptor.ModelDecorator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.RequestContext;
import org.springframework.extensions.surf.WebFrameworkServiceRegistry;
import org.springframework.extensions.surf.mvc.PageView;
import org.springframework.extensions.surf.support.ThreadLocalRequestContext;
import org.springframework.extensions.surf.types.Page;
import org.springframework.http.HttpStatus;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.handler.SimpleMappingExceptionResolver;

public class RepositoryExceptionResolver
extends SimpleMappingExceptionResolver {
    private static Log log = LogFactory.getLog(RepositoryExceptionResolver.class);
    private WebFrameworkServiceRegistry webFrameworkServiceRegistry;
    private String errorPageSuffix;
    private ModelDecorator modelDecorator;

    protected ModelAndView doResolveException(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        Section rootSection;
        if (!(ex instanceof RepositoryUnavailableException)) {
            log.error((Object)ex, (Throwable)ex);
        }
        Integer statusCode = ex instanceof PageNotFoundException ? Integer.valueOf(HttpStatus.NOT_FOUND.value()) : Integer.valueOf(HttpStatus.INTERNAL_SERVER_ERROR.value());
        RequestContext requestContext = ThreadLocalRequestContext.getRequestContext();
        if (requestContext != null && (rootSection = (Section)requestContext.getValue("rootSection")) != null) {
            String errorPage = statusCode + this.errorPageSuffix + ".html";
            Asset errorAsset = rootSection.getAsset(errorPage);
            Object template = null;
            if (errorAsset != null) {
                template = "errorpage";
            } else {
                String pageName = statusCode + this.errorPageSuffix;
                if (this.lookupPage(pageName) != null) {
                    template = pageName;
                }
            }
            if (template != null) {
                this.applyStatusCodeIfPossible(request, response, statusCode);
                PageView view = new PageView(requestContext.getServiceRegistry());
                view.setPage(this.lookupPage((String)template));
                view.setUrl((String)template);
                ModelAndView mv = new ModelAndView();
                mv.setView((View)view);
                try {
                    this.modelDecorator.populate(request, mv);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                mv.addObject("exception", (Object)ex);
                mv.addObject("errorAsset", (Object)errorAsset);
                return mv;
            }
        }
        return super.doResolveException(request, response, handler, ex);
    }

    private Page lookupPage(String pageId) {
        return this.webFrameworkServiceRegistry.getModelObjectService().getPage(pageId);
    }

    public void setErrorPageSuffix(String errorPageSuffix) {
        this.errorPageSuffix = errorPageSuffix;
    }

    public void setModelDecorator(ModelDecorator modelDecorator) {
        this.modelDecorator = modelDecorator;
    }

    public void setServiceRegistry(WebFrameworkServiceRegistry webFrameworkServiceRegistry) {
        this.webFrameworkServiceRegistry = webFrameworkServiceRegistry;
    }
}

