/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_wcmquickstart.benchmark;

import javax.annotation.Resource;
import junit.framework.Assert;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_wcmquickstart.benchmark.WebSiteGenerator;
import org.alfresco.repo.model.Repository;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.test.annotation.Commit;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:alfresco/module/org_alfresco_module_wcmquickstart/benchmark/website-generator-context.xml"})
@Commit
public class WebSiteRandomGeneratorTest {
    private static final String SITE_NAME = "testSite";
    @Resource(name="WebSiteGenerator")
    WebSiteGenerator generator;
    @Resource(name="NodeService")
    NodeService nodeService;
    @Resource(name="repositoryHelper")
    Repository repositoryHelper;

    @Test
    public void testGenerateWebSite() throws Exception {
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        NodeRef site = this.generator.generateWebSite(SITE_NAME);
        Assert.assertNotNull((Object)site);
        NodeRef companyHome = this.repositoryHelper.getCompanyHome();
        NodeRef webHome = this.nodeService.getChildByName(companyHome, ContentModel.ASSOC_CATEGORIES, "Alfresco Quick Start");
        Assert.assertNotNull((Object)webHome);
        NodeRef actualSite = this.nodeService.getChildByName(webHome, ContentModel.ASSOC_CATEGORIES, SITE_NAME);
        Assert.assertEquals((Object)site, (Object)actualSite);
    }
}

