/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_wcmquickstart.model;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.transaction.UserTransaction;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_wcmquickstart.WCMQuickStartTest;
import org.alfresco.module.org_alfresco_module_wcmquickstart.model.WebSiteModel;
import org.alfresco.repo.content.transform.AbstractContentTransformerTest;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.util.GUID;
import org.alfresco.util.PropertyMap;

public class WebRootModelTest
extends WCMQuickStartTest
implements WebSiteModel {
    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.authenticationComponent.setCurrentUser("admin");
    }

    private void createUser(String userName) {
        if (!this.authenticationService.authenticationExists(userName)) {
            this.authenticationService.createAuthentication(userName, "PWD".toCharArray());
            PropertyMap ppOne = new PropertyMap(4);
            ppOne.put((Object)ContentModel.PROP_USERNAME, (Object)userName);
            ppOne.put((Object)ContentModel.PROP_FIRSTNAME, (Object)"firstName");
            ppOne.put((Object)ContentModel.PROP_LASTNAME, (Object)"lastName");
            ppOne.put((Object)ContentModel.PROP_EMAIL, (Object)"email@email.com");
            ppOne.put((Object)ContentModel.PROP_JOBTITLE, (Object)"jobTitle");
            this.personService.createPerson((Map)ppOne);
        }
    }

    public void testWebSiteHierarchy() throws Exception {
        UserTransaction userTransaction = this.transactionService.getUserTransaction();
        userTransaction.begin();
        NodeRef section = this.fileFolderService.create(this.liveSiteRoot, "section", ContentModel.TYPE_FOLDER).getNodeRef();
        WebRootModelTest.assertNotNull((Object)section);
        WebRootModelTest.assertEquals((Object)TYPE_SECTION, (Object)this.nodeService.getType(section));
        NodeRef sectionChild = this.fileFolderService.create(section, "childSection", ContentModel.TYPE_FOLDER).getNodeRef();
        WebRootModelTest.assertNotNull((Object)sectionChild);
        WebRootModelTest.assertEquals((Object)TYPE_SECTION, (Object)this.nodeService.getType(sectionChild));
        NodeRef page = this.fileFolderService.create(sectionChild, "myFile.txt", ContentModel.TYPE_CONTENT).getNodeRef();
        ContentWriter writer = this.contentService.getWriter(page, ContentModel.PROP_CONTENT, true);
        writer.setEncoding("UTF-8");
        writer.setMimetype("text/html");
        writer.putContent("<html><head><title>Hello</title></head><body></body></html>");
        NodeRef nonpage = this.fileFolderService.create(sectionChild, "myFile.bob", ContentModel.TYPE_CONTENT).getNodeRef();
        writer = this.contentService.getWriter(nonpage, ContentModel.PROP_CONTENT, true);
        writer.setEncoding("UTF-8");
        writer.setMimetype("bob/frank");
        writer.putContent("Some asset only text.");
        userTransaction.commit();
        userTransaction = this.transactionService.getUserTransaction();
        userTransaction.begin();
        WebRootModelTest.assertTrue((String)"Page does not have webasset aspect applied.", (boolean)this.nodeService.hasAspect(page, ASPECT_WEBASSET));
        WebRootModelTest.assertTrue((String)"Non-page does not have webasset aspect applied.", (boolean)this.nodeService.hasAspect(nonpage, ASPECT_WEBASSET));
        WebRootModelTest.assertEquals((Object)TYPE_ARTICLE, (Object)this.nodeService.getType(page));
        WebRootModelTest.assertEquals((Object)ContentModel.TYPE_CONTENT, (Object)this.nodeService.getType(nonpage));
        List files = this.fileFolderService.listFiles(section);
        WebRootModelTest.assertEquals((int)1, (int)files.size());
        NodeRef index = ((FileInfo)files.get(0)).getNodeRef();
        WebRootModelTest.assertEquals((Object)TYPE_INDEX_PAGE, (Object)this.nodeService.getType(index));
        WebRootModelTest.assertTrue((boolean)this.nodeService.hasAspect(index, ASPECT_WEBASSET));
        WebRootModelTest.assertEquals((String)"index.html", (String)((String)((Object)this.nodeService.getProperty(index, ContentModel.PROP_NAME))));
        userTransaction.commit();
    }

    public void testCollections() throws Exception {
        UserTransaction userTransaction = this.transactionService.getUserTransaction();
        userTransaction.begin();
        this.testUserName = "testUser" + GUID.generate();
        this.createUser(this.testUserName);
        this.companyHome = this.repository.getCompanyHome();
        NodeRef webroot = this.fileFolderService.create(this.companyHome, "webroottest" + GUID.generate(), TYPE_WEB_ROOT).getNodeRef();
        NodeRef nonAsset = this.fileFolderService.create(this.companyHome, "nonasset" + GUID.generate() + ".txt", ContentModel.TYPE_CONTENT).getNodeRef();
        this.permissionService.setPermission(webroot, this.testUserName, "Coordinator", true);
        this.authenticationComponent.setCurrentUser(this.testUserName);
        NodeRef section = this.fileFolderService.create(webroot, "sectionOne", ContentModel.TYPE_FOLDER).getNodeRef();
        NodeRef webassetOne = this.fileFolderService.create(section, "one.txt", ContentModel.TYPE_CONTENT).getNodeRef();
        this.fileFolderService.create(section, "two.txt", ContentModel.TYPE_CONTENT).getNodeRef();
        this.fileFolderService.create(section, "three.txt", ContentModel.TYPE_CONTENT).getNodeRef();
        this.fileFolderService.create(section, "four.txt", TYPE_ARTICLE).getNodeRef();
        userTransaction.commit();
        userTransaction = this.transactionService.getUserTransaction();
        userTransaction.begin();
        List children = this.fileFolderService.listFolders(section);
        WebRootModelTest.assertEquals((int)1, (int)children.size());
        NodeRef collectionsFolder = ((FileInfo)children.get(0)).getNodeRef();
        WebRootModelTest.assertNotNull((Object)collectionsFolder);
        WebRootModelTest.assertEquals((Object)TYPE_WEBASSET_COLLECTION_FOLDER, (Object)this.nodeService.getType(collectionsFolder));
        NodeRef myCollection = this.fileFolderService.create(collectionsFolder, "myCollection", ContentModel.TYPE_FOLDER).getNodeRef();
        WebRootModelTest.assertEquals((Object)TYPE_WEBASSET_COLLECTION, (Object)this.nodeService.getType(myCollection));
        WebRootModelTest.assertNull((Object)this.nodeService.getProperty(myCollection, PROP_QUERY));
        WebRootModelTest.assertFalse((boolean)((Boolean)this.nodeService.getProperty(myCollection, PROP_IS_DYNAMIC)));
        this.nodeService.createAssociation(myCollection, webassetOne, ASSOC_WEBASSETS);
        WebRootModelTest.assertFalse((boolean)((Boolean)this.nodeService.getProperty(myCollection, PROP_IS_DYNAMIC)));
        userTransaction.commit();
        userTransaction = this.transactionService.getUserTransaction();
        userTransaction.begin();
        try {
            this.fileFolderService.create(myCollection, "anthing.txt", ContentModel.TYPE_CONTENT);
            WebRootModelTest.fail((String)"Shouldn't be able to create a child with in the collection");
        }
        catch (AlfrescoRuntimeException alfrescoRuntimeException) {
            // empty catch block
        }
        userTransaction.rollback();
        userTransaction = this.transactionService.getUserTransaction();
        userTransaction.begin();
        try {
            this.nodeService.createAssociation(myCollection, nonAsset, ASSOC_WEBASSETS);
            WebRootModelTest.fail((String)"Shouldn't be able to add a non-webasset to a collection");
        }
        catch (AlfrescoRuntimeException alfrescoRuntimeException) {
            // empty catch block
        }
        userTransaction.rollback();
        userTransaction = this.transactionService.getUserTransaction();
        userTransaction.begin();
        Object query = "select d.*, w.* from cmis:document as d join ws:webasset as w on d.cmis:objectId = w.cmis:objectId";
        this.nodeService.setProperty(myCollection, PROP_QUERY_RESULTS_MAX_SIZE, (Serializable)Integer.valueOf(3));
        this.nodeService.setProperty(myCollection, PROP_QUERY, (Serializable)query);
        WebRootModelTest.assertFalse((boolean)((Boolean)this.nodeService.getProperty(myCollection, PROP_IS_DYNAMIC)));
        userTransaction.commit();
        userTransaction = this.transactionService.getUserTransaction();
        userTransaction.begin();
        WebRootModelTest.assertTrue((boolean)((Boolean)this.nodeService.getProperty(myCollection, PROP_IS_DYNAMIC)));
        this.checkRefreshAfterNow(myCollection);
        List assocs = this.nodeService.getTargetAssocs(myCollection, (QNamePattern)ASSOC_WEBASSETS);
        WebRootModelTest.assertNotNull((Object)assocs);
        WebRootModelTest.assertEquals((int)3, (int)assocs.size());
        query = "TYPE:\"" + TYPE_ARTICLE.toString() + "\"";
        this.nodeService.setProperty(myCollection, PROP_QUERY_LANGUAGE, (Serializable)((Object)"lucene"));
        this.nodeService.setProperty(myCollection, PROP_QUERY, (Serializable)query);
        userTransaction.commit();
        userTransaction = this.transactionService.getUserTransaction();
        userTransaction.begin();
        WebRootModelTest.assertTrue((boolean)((Boolean)this.nodeService.getProperty(myCollection, PROP_IS_DYNAMIC)));
        this.checkRefreshAfterNow(myCollection);
        assocs = this.nodeService.getTargetAssocs(myCollection, (QNamePattern)ASSOC_WEBASSETS);
        WebRootModelTest.assertNotNull((Object)assocs);
        WebRootModelTest.assertTrue((assocs.size() > 0 ? 1 : 0) != 0);
        this.nodeService.setProperty(myCollection, PROP_QUERY, (Serializable)((Object)""));
        userTransaction.commit();
        userTransaction = this.transactionService.getUserTransaction();
        userTransaction.begin();
        assocs = this.nodeService.getTargetAssocs(myCollection, (QNamePattern)ASSOC_WEBASSETS);
        WebRootModelTest.assertNotNull((Object)assocs);
        WebRootModelTest.assertEquals((int)0, (int)assocs.size());
        WebRootModelTest.assertFalse((boolean)((Boolean)this.nodeService.getProperty(myCollection, PROP_IS_DYNAMIC)));
        query = "select d.*, w.* from cmis:document as d join ws:webasset as w on d.cmis:objectId = w.cmis:objectId where in_folder(d, '${sectionid}')";
        this.nodeService.setProperty(myCollection, PROP_QUERY_LANGUAGE, (Serializable)((Object)"cmis-alfresco"));
        this.nodeService.setProperty(myCollection, PROP_QUERY, (Serializable)query);
        userTransaction.commit();
        userTransaction = this.transactionService.getUserTransaction();
        userTransaction.begin();
        assocs = this.nodeService.getTargetAssocs(myCollection, (QNamePattern)ASSOC_WEBASSETS);
        WebRootModelTest.assertNotNull((Object)assocs);
        WebRootModelTest.assertEquals((int)3, (int)assocs.size());
        WebRootModelTest.assertTrue((boolean)((Boolean)this.nodeService.getProperty(myCollection, PROP_IS_DYNAMIC)));
        this.checkRefreshAfterNow(myCollection);
        query = "select d.*, w.* from cmis:document as d join ws:webasset as w on d.cmis:objectId = w.cmis:objectId where in_tree(d, '${siteid}')";
        this.nodeService.setProperty(myCollection, PROP_QUERY_LANGUAGE, (Serializable)((Object)"cmis-alfresco"));
        this.nodeService.setProperty(myCollection, PROP_QUERY, (Serializable)query);
        this.nodeService.setProperty(myCollection, PROP_QUERY_RESULTS_MAX_SIZE, (Serializable)Integer.valueOf(2));
        userTransaction.commit();
        userTransaction = this.transactionService.getUserTransaction();
        userTransaction.begin();
        assocs = this.nodeService.getTargetAssocs(myCollection, (QNamePattern)ASSOC_WEBASSETS);
        WebRootModelTest.assertNotNull((Object)assocs);
        WebRootModelTest.assertEquals((int)2, (int)assocs.size());
        WebRootModelTest.assertTrue((boolean)((Boolean)this.nodeService.getProperty(myCollection, PROP_IS_DYNAMIC)));
        this.checkRefreshAfterNow(myCollection);
        userTransaction.commit();
    }

    private void checkRefreshAfterNow(NodeRef collection) {
        Calendar now = Calendar.getInstance();
        Date refreshAt = (Date)this.nodeService.getProperty(collection, PROP_REFRESH_AT);
        WebRootModelTest.assertNotNull((Object)refreshAt);
        Calendar temp = Calendar.getInstance();
        temp.setTime(refreshAt);
        WebRootModelTest.assertTrue((boolean)now.before(temp));
    }

    public void testPDFWebassets() throws Exception {
        UserTransaction userTransaction = this.transactionService.getUserTransaction();
        userTransaction.begin();
        WebRootModelTest.assertNotNull((Object)this.liveSiteRoot);
        NodeRef section = this.fileFolderService.create(this.liveSiteRoot, "section", ContentModel.TYPE_FOLDER).getNodeRef();
        WebRootModelTest.assertNotNull((Object)section);
        WebRootModelTest.assertEquals((Object)TYPE_SECTION, (Object)this.nodeService.getType(section));
        List<String> renditionConfig = Collections.singletonList("application/msword=ws:pdfWebasset");
        this.nodeService.setProperty(section, PROP_RENDITION_CONFIG, (Serializable)((Object)renditionConfig));
        NodeRef doc = this.createContent(section, "testDoc.doc", "application/msword", "doc");
        userTransaction.commit();
        userTransaction = this.transactionService.getUserTransaction();
        userTransaction.begin();
        WebRootModelTest.assertTrue((boolean)this.nodeService.hasAspect(doc, ASPECT_WEBASSET));
        NodeRef docPdf = this.fileFolderService.searchSimple(section, "testDoc.pdf");
        WebRootModelTest.assertNotNull((Object)docPdf);
        WebRootModelTest.assertTrue((boolean)this.nodeService.hasAspect(docPdf, ASPECT_WEBASSET));
        userTransaction.commit();
    }

    private NodeRef createContent(NodeRef section, String name, String mimetype, String ext) throws IOException {
        NodeRef content = this.fileFolderService.create(section, name, ContentModel.TYPE_CONTENT).getNodeRef();
        ContentWriter writer = this.contentService.getWriter(content, ContentModel.PROP_CONTENT, true);
        writer.setEncoding("UTF-8");
        writer.setMimetype(mimetype);
        File origFile = AbstractContentTransformerTest.loadQuickTestFile((String)ext);
        writer.putContent(origFile);
        return content;
    }

    public void testSectionTracking() throws Exception {
        UserTransaction userTransaction = this.transactionService.getUserTransaction();
        userTransaction.begin();
        this.testUserName = "testUser" + GUID.generate();
        this.createUser(this.testUserName);
        this.permissionService.setPermission(this.liveSiteRoot, this.testUserName, "Coordinator", true);
        this.authenticationComponent.setCurrentUser(this.testUserName);
        NodeRef section1 = this.fileFolderService.create(this.liveSiteRoot, "sectionOne", ContentModel.TYPE_FOLDER).getNodeRef();
        NodeRef section2 = this.fileFolderService.create(this.liveSiteRoot, "sectionTwo", ContentModel.TYPE_FOLDER).getNodeRef();
        NodeRef webassetOne = this.fileFolderService.create(section1, "one.txt", ContentModel.TYPE_CONTENT).getNodeRef();
        NodeRef webassetTwo = this.fileFolderService.create(section1, "two.txt", ContentModel.TYPE_CONTENT).getNodeRef();
        NodeRef webassetThree = this.fileFolderService.create(section1, "three.txt", ContentModel.TYPE_CONTENT).getNodeRef();
        NodeRef webassetFour = this.fileFolderService.create(section1, "four.txt", ContentModel.TYPE_CONTENT).getNodeRef();
        userTransaction.commit();
        userTransaction = this.transactionService.getUserTransaction();
        userTransaction.begin();
        List parentSections = (List)((Object)this.nodeService.getProperty(webassetOne, PROP_PARENT_SECTIONS));
        WebRootModelTest.assertNotNull((Object)parentSections);
        WebRootModelTest.assertEquals((int)1, (int)parentSections.size());
        WebRootModelTest.assertEquals((Object)section1, parentSections.get(0));
        parentSections = (List)((Object)this.nodeService.getProperty(webassetTwo, PROP_PARENT_SECTIONS));
        WebRootModelTest.assertNotNull((Object)parentSections);
        WebRootModelTest.assertEquals((int)1, (int)parentSections.size());
        WebRootModelTest.assertEquals((Object)section1, parentSections.get(0));
        parentSections = (List)((Object)this.nodeService.getProperty(webassetFour, PROP_PARENT_SECTIONS));
        WebRootModelTest.assertNotNull((Object)parentSections);
        WebRootModelTest.assertEquals((int)1, (int)parentSections.size());
        WebRootModelTest.assertEquals((Object)section1, parentSections.get(0));
        this.fileFolderService.move(webassetOne, section2, null);
        this.fileFolderService.move(webassetTwo, section2, null);
        userTransaction.commit();
        userTransaction = this.transactionService.getUserTransaction();
        userTransaction.begin();
        parentSections = (List)((Object)this.nodeService.getProperty(webassetOne, PROP_PARENT_SECTIONS));
        WebRootModelTest.assertNotNull((Object)parentSections);
        WebRootModelTest.assertEquals((int)1, (int)parentSections.size());
        WebRootModelTest.assertEquals((Object)section2, parentSections.get(0));
        parentSections = (List)((Object)this.nodeService.getProperty(webassetTwo, PROP_PARENT_SECTIONS));
        WebRootModelTest.assertNotNull((Object)parentSections);
        WebRootModelTest.assertEquals((int)1, (int)parentSections.size());
        WebRootModelTest.assertEquals((Object)section2, parentSections.get(0));
        parentSections = (List)((Object)this.nodeService.getProperty(webassetThree, PROP_PARENT_SECTIONS));
        WebRootModelTest.assertNotNull((Object)parentSections);
        WebRootModelTest.assertEquals((int)1, (int)parentSections.size());
        WebRootModelTest.assertEquals((Object)section1, parentSections.get(0));
        parentSections = (List)((Object)this.nodeService.getProperty(webassetFour, PROP_PARENT_SECTIONS));
        WebRootModelTest.assertNotNull((Object)parentSections);
        WebRootModelTest.assertEquals((int)1, (int)parentSections.size());
        WebRootModelTest.assertEquals((Object)section1, parentSections.get(0));
        this.nodeService.addChild(section2, webassetThree, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"three.txt"));
        this.nodeService.addChild(section2, webassetFour, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"four.txt"));
        userTransaction.commit();
        userTransaction = this.transactionService.getUserTransaction();
        userTransaction.begin();
        parentSections = (List)((Object)this.nodeService.getProperty(webassetOne, PROP_PARENT_SECTIONS));
        WebRootModelTest.assertNotNull((Object)parentSections);
        WebRootModelTest.assertEquals((int)1, (int)parentSections.size());
        WebRootModelTest.assertEquals((Object)section2, parentSections.get(0));
        parentSections = (List)((Object)this.nodeService.getProperty(webassetTwo, PROP_PARENT_SECTIONS));
        WebRootModelTest.assertNotNull((Object)parentSections);
        WebRootModelTest.assertEquals((int)1, (int)parentSections.size());
        WebRootModelTest.assertEquals((Object)section2, parentSections.get(0));
        parentSections = (List)((Object)this.nodeService.getProperty(webassetThree, PROP_PARENT_SECTIONS));
        WebRootModelTest.assertNotNull((Object)parentSections);
        WebRootModelTest.assertEquals((int)2, (int)parentSections.size());
        WebRootModelTest.assertTrue((boolean)parentSections.contains(section1));
        WebRootModelTest.assertTrue((boolean)parentSections.contains(section2));
        parentSections = (List)((Object)this.nodeService.getProperty(webassetFour, PROP_PARENT_SECTIONS));
        WebRootModelTest.assertNotNull((Object)parentSections);
        WebRootModelTest.assertEquals((int)2, (int)parentSections.size());
        WebRootModelTest.assertTrue((boolean)parentSections.contains(section1));
        WebRootModelTest.assertTrue((boolean)parentSections.contains(section2));
        NodeRef copyOfWebAssetOne = this.fileFolderService.copy(webassetOne, section1, null).getNodeRef();
        userTransaction.commit();
        userTransaction = this.transactionService.getUserTransaction();
        userTransaction.begin();
        parentSections = (List)((Object)this.nodeService.getProperty(webassetOne, PROP_PARENT_SECTIONS));
        WebRootModelTest.assertNotNull((Object)parentSections);
        WebRootModelTest.assertEquals((int)1, (int)parentSections.size());
        WebRootModelTest.assertEquals((Object)section2, parentSections.get(0));
        parentSections = (List)((Object)this.nodeService.getProperty(copyOfWebAssetOne, PROP_PARENT_SECTIONS));
        WebRootModelTest.assertNotNull((Object)parentSections);
        WebRootModelTest.assertEquals((int)1, (int)parentSections.size());
        WebRootModelTest.assertEquals((Object)section1, parentSections.get(0));
        parentSections = (List)((Object)this.nodeService.getProperty(webassetTwo, PROP_PARENT_SECTIONS));
        WebRootModelTest.assertNotNull((Object)parentSections);
        WebRootModelTest.assertEquals((int)1, (int)parentSections.size());
        WebRootModelTest.assertEquals((Object)section2, parentSections.get(0));
        parentSections = (List)((Object)this.nodeService.getProperty(webassetThree, PROP_PARENT_SECTIONS));
        WebRootModelTest.assertNotNull((Object)parentSections);
        WebRootModelTest.assertEquals((int)2, (int)parentSections.size());
        WebRootModelTest.assertTrue((boolean)parentSections.contains(section1));
        WebRootModelTest.assertTrue((boolean)parentSections.contains(section2));
        parentSections = (List)((Object)this.nodeService.getProperty(webassetFour, PROP_PARENT_SECTIONS));
        WebRootModelTest.assertNotNull((Object)parentSections);
        WebRootModelTest.assertEquals((int)2, (int)parentSections.size());
        WebRootModelTest.assertTrue((boolean)parentSections.contains(section1));
        WebRootModelTest.assertTrue((boolean)parentSections.contains(section2));
        userTransaction.commit();
    }

    public void todoTestVisitorFeedback() throws Exception {
        UserTransaction userTransaction = this.transactionService.getUserTransaction();
        userTransaction.begin();
        this.testUserName = "testUser" + GUID.generate();
        this.createUser(this.testUserName);
        this.permissionService.setPermission(this.companyHome, this.testUserName, "Coordinator", true);
        this.authenticationComponent.setCurrentUser(this.testUserName);
        this.nodeService.setProperty(this.liveSite, PROP_FEEDBACK_CONFIG, (Serializable)((Object)"Contact Request=${websiteowner}"));
        NodeRef section = this.fileFolderService.create(this.liveSiteRoot, "section" + GUID.generate(), TYPE_SECTION).getNodeRef();
        NodeRef article1 = this.fileFolderService.create(section, "article" + GUID.generate(), TYPE_ARTICLE).getNodeRef();
        String name = "feedback" + GUID.generate();
        HashMap<QName, Object> props = new HashMap<QName, Object>();
        props.put(WebSiteModel.PROP_RELEVANT_ASSET, article1);
        props.put(ContentModel.PROP_NAME, name);
        props.put(PROP_FEEDBACK_TYPE, "Contact Request");
        NodeRef feedback2 = this.nodeService.createNode(this.liveSiteRoot, ContentModel.ASSOC_CONTAINS, QName.createQName((String)name), TYPE_VISITOR_FEEDBACK, props).getChildRef();
        userTransaction.commit();
        userTransaction = this.transactionService.getUserTransaction();
        userTransaction.begin();
        WebRootModelTest.assertEquals((Object)article1, (Object)this.nodeService.getProperty(feedback2, PROP_RELEVANT_ASSET));
        WebRootModelTest.assertFalse((boolean)this.nodeService.getTargetAssocs(feedback2, (QNamePattern)ASSOC_RELEVANT_ASSET).isEmpty());
        this.nodeService.deleteNode(article1);
        userTransaction.commit();
        userTransaction = this.transactionService.getUserTransaction();
        userTransaction.begin();
        WebRootModelTest.assertFalse((boolean)this.nodeService.exists(feedback2));
        userTransaction.commit();
    }
}

