/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_wcmquickstart.benchmark;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_wcmquickstart.benchmark.Tree;
import org.alfresco.module.org_alfresco_module_wcmquickstart.model.WebSiteModel;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;

public class WebSiteBuilder {
    private NodeService nodeService;

    public NodeRef buildSiteStructure(NodeRef parent, String siteName, Tree<String> siteStructure) {
        NodeRef website = this.makeWebSite(parent, siteName);
        String rootName = siteStructure.getRoot();
        NodeRef webRoot = this.makeWebRoot(website, rootName);
        this.generateSectionTree(webRoot, rootName, siteStructure);
        return website;
    }

    public NodeRef makeWebSite(NodeRef parent, String siteName) {
        HashMap<QName, Serializable> properties = new HashMap<QName, Serializable>();
        ArrayList<String> siteSectionConfigs = new ArrayList<String>(1);
        siteSectionConfigs.add("isEditorial=false");
        properties.put(WebSiteModel.PROP_SECTION_CONFIG, siteSectionConfigs);
        return this.createNode(parent, siteName, WebSiteModel.TYPE_WEB_SITE, properties);
    }

    public NodeRef makeSection(NodeRef parent, String sectionName) {
        return this.createNode(parent, sectionName, WebSiteModel.TYPE_SECTION, null);
    }

    public NodeRef makeWebRoot(NodeRef website, String rootName) {
        HashMap<QName, Serializable> properties = new HashMap<QName, Serializable>();
        ArrayList<String> values = new ArrayList<String>(3);
        values.add("ws:image=ws:smallThumbnail");
        values.add("ws:image=ws:imagePreview");
        values.add("application/pdf=ws:swfPreview");
        properties.put(WebSiteModel.PROP_RENDITION_CONFIG, values);
        properties.put(ContentModel.PROP_TITLE, (Serializable)((Object)"Home"));
        properties.put(ContentModel.PROP_DESCRIPTION, (Serializable)((Object)rootName));
        ArrayList<String> rootSectionConfigs = new ArrayList<String>(3);
        rootSectionConfigs.add("ws:indexPage=sectionpage1");
        rootSectionConfigs.add("ws:article=articlepage1");
        rootSectionConfigs.add("cmis:document=baseTemplate");
        properties.put(WebSiteModel.PROP_SECTION_CONFIG, rootSectionConfigs);
        properties.put(WebSiteModel.PROP_INHERIT_RENDITION_CONFIG, Boolean.valueOf(true));
        properties.put(WebSiteModel.ASPECT_HAS_ANCESTORS, null);
        return this.createNode(website, rootName, WebSiteModel.TYPE_WEB_ROOT, properties);
    }

    private NodeRef createNode(NodeRef parent, String name, QName type, Map<QName, Serializable> properties) {
        if (properties == null) {
            properties = new HashMap<QName, Serializable>();
        }
        properties.put(ContentModel.PROP_NAME, (Serializable)((Object)name));
        String localName = QName.createValidLocalName((String)name);
        QName assocName = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)localName);
        return this.nodeService.createNode(parent, ContentModel.ASSOC_CONTAINS, assocName, type, properties).getChildRef();
    }

    private void generateSectionTree(NodeRef parent, String parentName, Tree<String> siteStructure) {
        for (String sectionName : siteStructure.getChildren(parentName)) {
            NodeRef section = this.makeSection(parent, sectionName);
            this.generateSectionTree(section, sectionName, siteStructure);
        }
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }
}

