/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_wcmquickstart.publish;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_wcmquickstart.model.WebSiteModel;
import org.alfresco.module.org_alfresco_module_wcmquickstart.publish.NodeCrawlerConfigurer;
import org.alfresco.module.org_alfresco_module_wcmquickstart.publish.PublishService;
import org.alfresco.module.org_alfresco_module_wcmquickstart.publish.TransferPathMapper;
import org.alfresco.module.org_alfresco_module_wcmquickstart.util.SiteHelper;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.Path;
import org.alfresco.service.cmr.transfer.NodeCrawler;
import org.alfresco.service.cmr.transfer.NodeCrawlerFactory;
import org.alfresco.service.cmr.transfer.TransferCallback;
import org.alfresco.service.cmr.transfer.TransferDefinition;
import org.alfresco.service.cmr.transfer.TransferFailureException;
import org.alfresco.service.cmr.transfer.TransferService2;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.GUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PublishServiceImpl
implements PublishService {
    private static final Log log = LogFactory.getLog(PublishServiceImpl.class);
    private static final String PUBLISH_QUEUE_NAME = "publishingQueue";
    private static final Set<String> DEFAULT_ASPECTS_TO_EXCLUDE = new TreeSet<String>();
    private TransactionService transactionService;
    private SiteHelper siteHelper;
    private NodeService nodeService;
    private TransferService2 transferService;
    private NamespaceService namespaceService;
    private TransferPathMapper pathMapper;
    private NodeCrawlerFactory nodeCrawlerFactory;
    private NodeCrawlerConfigurer crawlerConfigurer;
    private String transferTargetName = "Internal Target";
    private Set<String> aspectsToExclude = DEFAULT_ASPECTS_TO_EXCLUDE;
    private int maxPublishAttempts = 3;

    public void setSiteHelper(SiteHelper siteHelper) {
        this.siteHelper = siteHelper;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setTransferService(TransferService2 transferService) {
        this.transferService = transferService;
    }

    public void setTransferTargetName(String transferTargetName) {
        this.transferTargetName = transferTargetName;
    }

    public void setPathMapper(TransferPathMapper pathMapper) {
        this.pathMapper = pathMapper;
    }

    public void setNodeCrawlerFactory(NodeCrawlerFactory nodeCrawlerFactory) {
        this.nodeCrawlerFactory = nodeCrawlerFactory;
    }

    public void setCrawlerConfigurer(NodeCrawlerConfigurer crawlerConfigurer) {
        this.crawlerConfigurer = crawlerConfigurer;
    }

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    public void setAspectsToExclude(Collection<String> aspectsToExclude) {
        this.aspectsToExclude = aspectsToExclude == null ? new TreeSet<String>() : new TreeSet<String>(aspectsToExclude);
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    public void setMaxPublishAttempts(int maxPublishAttempts) {
        this.maxPublishAttempts = maxPublishAttempts;
    }

    @Override
    public void enqueuePublishedNodes(NodeRef ... nodes) {
        this.enqueueNodes(false, nodes);
    }

    @Override
    public void enqueuePublishedNodes(Collection<NodeRef> nodes) {
        this.enqueuePublishedNodes(nodes.toArray(new NodeRef[nodes.size()]));
    }

    @Override
    public void enqueueRemovedNodes(final NodeRef ... nodes) {
        AuthenticationUtil.runAsSystem((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() throws Exception {
                PublishServiceImpl.this.enqueueNodes(true, nodes);
                return null;
            }
        });
    }

    @Override
    public void enqueueRemovedNodes(Collection<NodeRef> nodes) {
        this.enqueueRemovedNodes(nodes.toArray(new NodeRef[nodes.size()]));
    }

    public void enqueueNodes(boolean remove, NodeRef ... nodes) {
        if (nodes != null && nodes.length > 0) {
            NodeRef publishingQueue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Request to enqueue these nodes for publishing: " + String.valueOf(Arrays.asList(nodes))));
            }
            if ((publishingQueue = this.siteHelper.getWebSiteContainer(nodes[0], PUBLISH_QUEUE_NAME)) != null && !this.nodeService.hasAspect(publishingQueue, ContentModel.ASPECT_PENDING_DELETE)) {
                for (NodeRef node : nodes) {
                    HashMap<QName, Object> props = new HashMap<QName, Object>();
                    String name = GUID.generate();
                    props.put(ContentModel.PROP_NAME, name);
                    props.put(WebSiteModel.PROP_QUEUED_NODE, node.toString());
                    props.put(WebSiteModel.PROP_QUEUED_NODE_FOR_REMOVAL, remove);
                    this.nodeService.createNode(publishingQueue, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/website/1.0", (String)name), WebSiteModel.TYPE_PUBLISH_QUEUE_ENTRY, props);
                }
            }
        }
    }

    @Override
    public void publishQueue(NodeRef websiteId) {
        if (websiteId == null) {
            throw new IllegalArgumentException("websiteId == " + String.valueOf(websiteId));
        }
        NodeRef targetSite = null;
        List targets = this.nodeService.getTargetAssocs(websiteId, (QNamePattern)WebSiteModel.ASSOC_PUBLISH_TARGET);
        if (!targets.isEmpty()) {
            targetSite = ((AssociationRef)targets.get(0)).getTargetRef();
            Path sourcePath = this.nodeService.getPath(websiteId);
            Path targetPath = this.nodeService.getPath(targetSite);
            this.pathMapper.addPathMapping(sourcePath, targetPath);
            Set<NodeRef> nodesToTransfer = new HashSet(89);
            HashSet<NodeRef> nodesToRemoveOnTransfer = new HashSet<NodeRef>(89);
            NodeRef queue = this.siteHelper.getWebSiteContainer(websiteId, PUBLISH_QUEUE_NAME);
            if (queue != null) {
                List publishedNodes = this.nodeService.getChildAssocs(queue, (QNamePattern)ContentModel.ASSOC_CONTAINS, RegexQNamePattern.MATCH_ALL);
                for (ChildAssociationRef assoc : publishedNodes) {
                    NodeRef queueEntry = assoc.getChildRef();
                    NodeRef node = new NodeRef((String)((Object)this.nodeService.getProperty(queueEntry, WebSiteModel.PROP_QUEUED_NODE)));
                    boolean remove = (Boolean)this.nodeService.getProperty(queueEntry, WebSiteModel.PROP_QUEUED_NODE_FOR_REMOVAL);
                    if (remove) {
                        nodesToRemoveOnTransfer.add(node);
                        continue;
                    }
                    nodesToTransfer.add(node);
                }
                if (!nodesToTransfer.isEmpty() || !nodesToRemoveOnTransfer.isEmpty()) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("PublishService is about to crawl these nodes: " + String.valueOf(nodesToTransfer)));
                    }
                    NodeCrawler crawler = this.nodeCrawlerFactory.getNodeCrawler();
                    this.configureNodeCrawler(crawler);
                    nodesToTransfer = crawler.crawl(nodesToTransfer);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("PublishService has crawled the queued nodes and is about to transfer these nodes: " + String.valueOf(nodesToTransfer)));
                    }
                    TransferDefinition def = new TransferDefinition();
                    def.setNodes(nodesToTransfer);
                    def.setNodesToRemove(nodesToRemoveOnTransfer);
                    HashSet<QName> aspectQNames = new HashSet<QName>();
                    for (String aspectToExclude : this.aspectsToExclude) {
                        aspectQNames.add(QName.createQName((String)aspectToExclude, (NamespacePrefixResolver)this.namespaceService));
                    }
                    def.setExcludedAspects(aspectQNames);
                    try {
                        this.transferService.transfer(this.transferTargetName, def, new TransferCallback[0]);
                    }
                    catch (TransferFailureException e) {
                        final List finalPublishedNodes = publishedNodes;
                        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

                            public Object execute() throws Throwable {
                                for (ChildAssociationRef childRef : finalPublishedNodes) {
                                    Integer failedAttCount = (Integer)PublishServiceImpl.this.nodeService.getProperty(childRef.getChildRef(), WebSiteModel.PROP_FAILED_ATTEMPTS_COUNT);
                                    if (failedAttCount == null) {
                                        failedAttCount = 0;
                                    }
                                    Integer n = failedAttCount;
                                    failedAttCount = failedAttCount + 1;
                                    if (failedAttCount == PublishServiceImpl.this.maxPublishAttempts) {
                                        PublishServiceImpl.this.nodeService.deleteNode(childRef.getChildRef());
                                        continue;
                                    }
                                    PublishServiceImpl.this.nodeService.setProperty(childRef.getChildRef(), WebSiteModel.PROP_FAILED_ATTEMPTS_COUNT, (Serializable)failedAttCount);
                                }
                                return null;
                            }
                        }, false, true);
                        throw e;
                    }
                    for (ChildAssociationRef assoc : publishedNodes) {
                        this.nodeService.deleteNode(assoc.getChildRef());
                    }
                }
            } else {
                log.warn((Object)("Discovered a website node that is outside of a Share site. Skipping. " + String.valueOf(websiteId)));
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("Request has been made to publish from a site that has no target configured: " + String.valueOf(websiteId)));
        }
    }

    protected void configureNodeCrawler(NodeCrawler crawler) {
        this.crawlerConfigurer.configure(crawler);
    }

    @Override
    public String getTransferTargetName() {
        return this.transferTargetName;
    }

    static {
        DEFAULT_ASPECTS_TO_EXCLUDE.add("fm:discussable");
    }
}

