/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_wcmquickstart.publish;

import jakarta.transaction.UserTransaction;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_wcmquickstart.model.WebSiteModel;
import org.alfresco.module.org_alfresco_module_wcmquickstart.publish.PublishService;
import org.alfresco.repo.model.Repository;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.cmr.transfer.TransferService2;
import org.alfresco.service.cmr.transfer.TransferTarget;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.BaseApplicationContextHelper;
import org.alfresco.util.GUID;
import org.alfresco.util.PropertyMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContext;

public class PublishTest
extends TestCase
implements WebSiteModel {
    private static final Log log = LogFactory.getLog(PublishTest.class);
    private ApplicationContext appContext;
    private AuthenticationComponent authenticationComponent;
    private TransactionService transactionService;
    private FileFolderService fileFolderService;
    private NodeService nodeService;
    private Repository repository;
    private ContentService contentService;
    private MutableAuthenticationService authenticationService;
    private PersonService personService;
    NodeRef companyHome;
    String testUserName;
    private TransferService2 transferService;
    private PublishService publishService;

    protected void setUp() throws Exception {
        this.appContext = BaseApplicationContextHelper.getApplicationContext((String[])new String[]{"classpath:alfresco/application-context.xml", "classpath:alfresco/module/org_alfresco_module_wcmquickstart/module-context.xml"});
        this.authenticationComponent = (AuthenticationComponent)this.appContext.getBean("authenticationComponent");
        this.transactionService = (TransactionService)this.appContext.getBean("transactionService");
        this.fileFolderService = (FileFolderService)this.appContext.getBean("fileFolderService");
        this.nodeService = (NodeService)this.appContext.getBean("nodeService");
        this.repository = (Repository)this.appContext.getBean("repositoryHelper");
        this.contentService = (ContentService)this.appContext.getBean("contentService");
        this.authenticationService = (MutableAuthenticationService)this.appContext.getBean("authenticationService");
        this.personService = (PersonService)this.appContext.getBean("personService");
        this.transferService = (TransferService2)this.appContext.getBean("org_alfresco_module_wcmquickstart_transferService");
        this.publishService = (PublishService)this.appContext.getBean("org_alfresco_module_wcmquickstart_publishingService");
        this.authenticationComponent.setCurrentUser("admin");
    }

    private void createUser(String userName) {
        if (!this.authenticationService.authenticationExists(userName)) {
            this.authenticationService.createAuthentication(userName, "PWD".toCharArray());
            PropertyMap ppOne = new PropertyMap(4);
            ppOne.put((Object)ContentModel.PROP_USERNAME, (Object)userName);
            ppOne.put((Object)ContentModel.PROP_FIRSTNAME, (Object)"firstName");
            ppOne.put((Object)ContentModel.PROP_LASTNAME, (Object)"lastName");
            ppOne.put((Object)ContentModel.PROP_EMAIL, (Object)"email@email.com");
            ppOne.put((Object)ContentModel.PROP_JOBTITLE, (Object)"jobTitle");
            this.personService.createPerson((Map)ppOne);
        }
    }

    public void test() {
    }

    public void xtestWebSiteHierarchy() throws Exception {
        UserTransaction userTransaction = this.transactionService.getUserTransaction();
        userTransaction.begin();
        this.companyHome = this.repository.getCompanyHome();
        NodeRef editorialWebroot = this.fileFolderService.create(this.companyHome, "editorial" + GUID.generate(), ContentModel.TYPE_FOLDER).getNodeRef();
        PublishTest.assertNotNull((Object)editorialWebroot);
        this.nodeService.setType(editorialWebroot, TYPE_WEB_SITE);
        NodeRef liveWebroot = this.fileFolderService.create(this.companyHome, "live" + GUID.generate(), ContentModel.TYPE_FOLDER).getNodeRef();
        PublishTest.assertNotNull((Object)liveWebroot);
        this.nodeService.setType(liveWebroot, TYPE_WEB_SITE);
        this.nodeService.createAssociation(editorialWebroot, liveWebroot, WebSiteModel.ASSOC_PUBLISH_TARGET);
        NodeRef section = this.fileFolderService.create(editorialWebroot, "section", WebSiteModel.TYPE_WEB_ROOT).getNodeRef();
        PublishTest.assertNotNull((Object)section);
        NodeRef sectionChild = this.fileFolderService.create(section, "childSection", ContentModel.TYPE_FOLDER).getNodeRef();
        PublishTest.assertNotNull((Object)sectionChild);
        PublishTest.assertEquals((Object)TYPE_SECTION, (Object)this.nodeService.getType(sectionChild));
        NodeRef page = this.fileFolderService.create(sectionChild, "myFile.txt", ContentModel.TYPE_CONTENT).getNodeRef();
        ContentWriter writer = this.contentService.getWriter(page, ContentModel.PROP_CONTENT, true);
        writer.setEncoding("UTF-8");
        writer.setMimetype("text/html");
        writer.putContent("<html><head><title>Hello</title></head><body></body></html>");
        NodeRef nonpage = this.fileFolderService.create(sectionChild, "myFile.bob", ContentModel.TYPE_CONTENT).getNodeRef();
        writer = this.contentService.getWriter(nonpage, ContentModel.PROP_CONTENT, true);
        writer.setEncoding("UTF-8");
        writer.setMimetype("text/plain");
        writer.putContent("Some asset only text.");
        userTransaction.commit();
        userTransaction = this.transactionService.getUserTransaction();
        userTransaction.begin();
        PublishTest.assertTrue((String)"Page does not have webasset aspect applied.", (boolean)this.nodeService.hasAspect(page, ASPECT_WEBASSET));
        PublishTest.assertTrue((String)"Non-page does not have webasset aspect applied.", (boolean)this.nodeService.hasAspect(nonpage, ASPECT_WEBASSET));
        String targetName = "test" + GUID.generate();
        TransferTarget transferTarget = this.transferService.createTransferTarget(targetName);
        transferTarget.setUsername("user");
        transferTarget.setPassword("hello".toCharArray());
        transferTarget.setEndpointHost("host");
        transferTarget.setEndpointProtocol("http");
        transferTarget.setEndpointPort(80);
        this.transferService.saveTransferTarget(transferTarget);
        userTransaction.commit();
        Thread.sleep(200L);
        userTransaction = this.transactionService.getUserTransaction();
        userTransaction.begin();
        this.publishService.enqueuePublishedNodes(new NodeRef[]{section, sectionChild, page});
        long start = System.currentTimeMillis();
        this.publishService.publishQueue(editorialWebroot);
        userTransaction.commit();
        log.debug((Object)("Transfer took " + (System.currentTimeMillis() - start) + "ms"));
        userTransaction = this.transactionService.getUserTransaction();
        userTransaction.begin();
        PublishTest.assertFalse((boolean)this.nodeService.getChildAssocs(liveWebroot).isEmpty());
        NodeRef liveSection = this.fileFolderService.searchSimple(liveWebroot, "section");
        PublishTest.assertNotNull((Object)liveSection);
        PublishTest.assertTrue((boolean)TYPE_SECTION.equals((Object)this.nodeService.getType(liveSection)));
        NodeRef liveChildSection = this.fileFolderService.searchSimple(liveSection, "childSection");
        PublishTest.assertNotNull((Object)liveChildSection);
        PublishTest.assertTrue((boolean)TYPE_SECTION.equals((Object)this.nodeService.getType(liveChildSection)));
        NodeRef livePage = this.fileFolderService.searchSimple(liveChildSection, "myFile.txt");
        PublishTest.assertNotNull((Object)livePage);
        PublishTest.assertNotNull((Object)this.nodeService.getProperty(livePage, PROP_PARENT_SECTIONS));
        PublishTest.assertTrue((boolean)((List)((Object)this.nodeService.getProperty(livePage, PROP_PARENT_SECTIONS))).contains(liveChildSection));
        userTransaction.commit();
    }
}

