/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_wcmquickstart.publish;

import org.alfresco.service.cmr.repository.NodeRef;

public class NodeRefMapper {
    public NodeRef mapSourceNodeRef(NodeRef node) {
        StringBuilder nodeId = new StringBuilder(node.getId());
        if (nodeId.length() == 36) {
            for (int index = 35; index >= 0; --index) {
                int destChar;
                char srcChar = nodeId.charAt(index);
                if (srcChar == '-' || (destChar = this.srcCharToDestChar(srcChar)) == srcChar) continue;
                nodeId.setCharAt(index, (char)destChar);
                break;
            }
        } else {
            nodeId.append('f');
        }
        return new NodeRef(node.getStoreRef(), nodeId.toString());
    }

    public NodeRef mapDestinationNodeRef(NodeRef node) {
        StringBuilder nodeId = new StringBuilder(node.getId());
        if (node.getId().endsWith("f")) {
            nodeId.deleteCharAt(nodeId.length() - 1);
        } else {
            int lastDestCharIndex = nodeId.length();
            int lastDestChar = 0;
            for (int index = nodeId.length() - 1; index >= 0; --index) {
                char destChar = nodeId.charAt(index);
                if (destChar == '-') continue;
                if (!this.isDestChar(destChar)) break;
                lastDestCharIndex = index;
                lastDestChar = destChar;
            }
            if (lastDestCharIndex < nodeId.length()) {
                int srcChar = this.destCharToSrcChar(lastDestChar);
                nodeId.setCharAt(lastDestCharIndex, (char)srcChar);
            }
        }
        return new NodeRef(node.getStoreRef(), nodeId.toString());
    }

    private int srcCharToDestChar(int ch) {
        int result = ch;
        if (ch >= 48 && ch <= 57) {
            result = ch - 48 + 65;
        } else if (ch >= 97 && ch <= 102) {
            result = ch - 97 + 10 + 65;
        }
        return result;
    }

    private int destCharToSrcChar(int ch) {
        int result = ch;
        if (ch >= 65 && ch <= 74) {
            result = ch - 65 + 48;
        } else if (ch >= 75 && ch <= 80) {
            result = ch - 75 + 97;
        }
        return result;
    }

    private boolean isDestChar(int ch) {
        return ch >= 65 && ch <= 80;
    }
}

