/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_wcmquickstart.publish;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.alfresco.module.org_alfresco_module_wcmquickstart.model.WebSiteModel;
import org.alfresco.repo.transfer.AbstractNodeFinder;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;

public class UpwardsSectionFinder
extends AbstractNodeFinder {
    private NodeService nodeService;
    private DictionaryService dictionaryService;

    public void init() {
        super.init();
        this.nodeService = this.serviceRegistry.getNodeService();
        this.dictionaryService = this.serviceRegistry.getDictionaryService();
    }

    public Set<NodeRef> findFrom(NodeRef thisNode) {
        List parentSections;
        Set<NodeRef> result = Collections.emptySet();
        if (this.dictionaryService.isSubClass(this.nodeService.getType(thisNode), WebSiteModel.TYPE_SECTION)) {
            result = new HashSet(23);
            NodeRef parent = this.nodeService.getPrimaryParent(thisNode).getParentRef();
            if (parent != null && this.dictionaryService.isSubClass(this.nodeService.getType(thisNode), WebSiteModel.TYPE_SECTION)) {
                result.add(parent);
            }
        } else if (this.nodeService.hasAspect(thisNode, WebSiteModel.ASPECT_WEBASSET) && (parentSections = (List)((Object)this.nodeService.getProperty(thisNode, WebSiteModel.PROP_PARENT_SECTIONS))) != null) {
            result = new HashSet<NodeRef>(23);
            result.addAll(parentSections);
        }
        return result;
    }
}

