/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_wcmquickstart.webscript;

import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_wcmquickstart.model.WebSiteModel;
import org.alfresco.module.org_alfresco_module_wcmquickstart.util.AssetSerializer;
import org.alfresco.module.org_alfresco_module_wcmquickstart.util.AssetSerializerFactory;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.springframework.extensions.webscripts.AbstractWebScript;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;
import org.springframework.extensions.webscripts.WebScriptResponse;

public class AssetCollectionGet
extends AbstractWebScript
implements WebSiteModel {
    private static final String PARAM_COLLECTION_ID = "assetcollectionid";
    private static final String PARAM_COLLECTION_NAME = "name";
    private static final String PARAM_SECTION_ID = "sectionid";
    private static final String PARAM_MODIFIED_TIME_ONLY = "modifiedTimeOnly";
    private NodeService nodeService;
    private FileFolderService fileFolderService;
    private AssetSerializerFactory assetSerializerFactory;

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setFileFolderService(FileFolderService fileFolderService) {
        this.fileFolderService = fileFolderService;
    }

    public void setAssetSerializerFactory(AssetSerializerFactory assetSerializerFactory) {
        this.assetSerializerFactory = assetSerializerFactory;
    }

    public void execute(WebScriptRequest req, WebScriptResponse res) throws IOException {
        NodeRef collection;
        String collectionId = req.getParameter(PARAM_COLLECTION_ID);
        if (collectionId == null) {
            Map templateVars = req.getServiceMatch().getTemplateVars();
            String collectionName = (String)templateVars.get(PARAM_COLLECTION_NAME);
            if (collectionName == null || collectionName.length() == 0) {
                throw new WebScriptException(404, "No collection name was provided on the URL.");
            }
            String sectionId = req.getParameter(PARAM_SECTION_ID);
            if (sectionId == null || sectionId.length() == 0) {
                throw new WebScriptException(400, "No section id parameter specified.");
            }
            if (!NodeRef.isNodeRef((String)sectionId)) {
                throw new WebScriptException(400, "No section id is not a valid Alfresco node reference. ( " + sectionId + ")");
            }
            NodeRef sectionNodeRef = new NodeRef(sectionId);
            NodeRef collectionsNodeRef = this.fileFolderService.searchSimple(sectionNodeRef, "collections");
            if (collectionsNodeRef == null) {
                throw new WebScriptException(404, "The collections folder for the section " + sectionId + " could not be found.");
            }
            collection = this.fileFolderService.searchSimple(collectionsNodeRef, collectionName);
            if (collection == null) {
                throw new WebScriptException(404, "Unable to find collection " + collectionName + " in section " + sectionId);
            }
        } else {
            if (collectionId.length() == 0) {
                throw new WebScriptException(400, "No collection id parameter specified.");
            }
            if (!NodeRef.isNodeRef((String)collectionId)) {
                throw new WebScriptException(400, "The collection id is not a valid Alfresco node reference. ( " + collectionId + ")");
            }
            collection = new NodeRef(collectionId);
        }
        try {
            Map<QName, Serializable> collectionProps;
            boolean onlyModifiedTime = req.getParameter(PARAM_MODIFIED_TIME_ONLY) != null;
            AssetSerializer assetSerializer = this.assetSerializerFactory.getAssetSerializer();
            res.setContentEncoding("UTF-8");
            res.setContentType(assetSerializer.getMimeType());
            Writer writer = res.getWriter();
            if (onlyModifiedTime) {
                collectionProps = new HashMap(3);
                collectionProps.put(ContentModel.PROP_MODIFIED, this.nodeService.getProperty(collection, ContentModel.PROP_MODIFIED));
            } else {
                collectionProps = this.nodeService.getProperties(collection);
                if (!collectionProps.containsKey(PROP_CONTAINED_ASSETS)) {
                    List assocs = this.nodeService.getTargetAssocs(collection, (QNamePattern)ASSOC_WEBASSETS);
                    ArrayList<NodeRef> containedAssets = new ArrayList<NodeRef>(assocs.size());
                    for (AssociationRef assoc : assocs) {
                        containedAssets.add(assoc.getTargetRef());
                    }
                    collectionProps.put(PROP_CONTAINED_ASSETS, containedAssets);
                }
            }
            assetSerializer.start(writer);
            QName typeName = this.nodeService.getType(collection);
            assetSerializer.writeNode(collection, typeName, collectionProps);
            assetSerializer.end();
        }
        catch (Throwable e) {
            throw this.createStatusException(e, req, res);
        }
    }
}

