/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_wcmquickstart.model;

import java.io.Serializable;
import java.util.Map;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_wcmquickstart.model.WebSiteModel;
import org.alfresco.module.org_alfresco_module_wcmquickstart.util.WebassetCollectionHelper;
import org.alfresco.repo.node.NodeServicePolicies;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;

public class WebassetCollectionType
implements WebSiteModel,
NodeServicePolicies.OnUpdatePropertiesPolicy,
NodeServicePolicies.OnCreateChildAssociationPolicy,
NodeServicePolicies.OnCreateAssociationPolicy {
    private PolicyComponent policyComponent;
    private NodeService nodeService;
    private JavaBehaviour onCreateAssociation;
    private WebassetCollectionHelper collectionHelper;

    public void setPolicyComponent(PolicyComponent policyComponent) {
        this.policyComponent = policyComponent;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setCollectionHelper(WebassetCollectionHelper collectionHelper) {
        this.collectionHelper = collectionHelper;
    }

    public void init() {
        this.policyComponent.bindClassBehaviour(NodeServicePolicies.OnUpdatePropertiesPolicy.QNAME, TYPE_WEBASSET_COLLECTION, (Behaviour)new JavaBehaviour((Object)this, "onUpdateProperties", Behaviour.NotificationFrequency.TRANSACTION_COMMIT));
        this.policyComponent.bindAssociationBehaviour(NodeServicePolicies.OnCreateChildAssociationPolicy.QNAME, TYPE_WEBASSET_COLLECTION, ContentModel.ASSOC_CONTAINS, (Behaviour)new JavaBehaviour((Object)this, "onCreateChildAssociation", Behaviour.NotificationFrequency.FIRST_EVENT));
        this.onCreateAssociation = new JavaBehaviour((Object)this, "onCreateAssociation", Behaviour.NotificationFrequency.FIRST_EVENT);
        this.policyComponent.bindAssociationBehaviour(NodeServicePolicies.OnCreateAssociationPolicy.QNAME, TYPE_WEBASSET_COLLECTION, ASSOC_WEBASSETS, (Behaviour)this.onCreateAssociation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onUpdateProperties(NodeRef nodeRef, Map<QName, Serializable> before, Map<QName, Serializable> after) {
        this.onCreateAssociation.disable();
        try {
            String queryBefore = this.makeNull((String)((Object)before.get(PROP_QUERY)));
            String queryAfter = this.makeNull((String)((Object)after.get(PROP_QUERY)));
            if (queryBefore == null && queryAfter != null || queryBefore != null && queryAfter != null && !queryBefore.equals(queryAfter)) {
                this.collectionHelper.refreshCollection(nodeRef);
                this.nodeService.setProperty(nodeRef, PROP_IS_DYNAMIC, (Serializable)Boolean.valueOf(true));
            } else if (queryBefore != null && queryAfter == null) {
                this.collectionHelper.clearCollection(nodeRef);
                this.nodeService.setProperty(nodeRef, PROP_IS_DYNAMIC, (Serializable)Boolean.valueOf(false));
            }
        }
        finally {
            this.onCreateAssociation.enable();
        }
    }

    private String makeNull(String value) {
        String result = value;
        if (value != null && value.trim().length() == 0) {
            result = null;
        }
        return result;
    }

    public void onCreateChildAssociation(ChildAssociationRef childAssocRef, boolean isNewNode) {
        throw new AlfrescoRuntimeException("Content or folders can not be created or added within a resource collection.");
    }

    public void onCreateAssociation(AssociationRef nodeAssocRef) {
        if (!this.nodeService.hasAspect(nodeAssocRef.getTargetRef(), ASPECT_WEBASSET)) {
            throw new AlfrescoRuntimeException("Can not add resource to a collection unless it is an asset.");
        }
    }
}

