/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_wcmquickstart;

import jakarta.transaction.UserTransaction;
import junit.framework.TestCase;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_wcmquickstart.model.WebSiteModel;
import org.alfresco.repo.model.Repository;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.cmr.site.SiteInfo;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.service.cmr.site.SiteVisibility;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ApplicationContextHelper;
import org.springframework.context.ApplicationContext;

public abstract class WCMQuickStartTest
extends TestCase {
    protected ApplicationContext appContext;
    protected AuthenticationComponent authenticationComponent;
    protected TransactionService transactionService;
    protected FileFolderService fileFolderService;
    protected NodeService nodeService;
    protected Repository repository;
    protected ContentService contentService;
    protected MutableAuthenticationService authenticationService;
    protected PersonService personService;
    protected PermissionService permissionService;
    private SiteService siteService;
    protected NodeRef companyHome;
    protected String testUserName;
    private String testSiteName = "WCM_QS_TEST_SITE";
    protected SiteInfo site;
    protected NodeRef editorialSite;
    protected NodeRef editorialSiteRoot;
    protected NodeRef liveSite;
    protected NodeRef liveSiteRoot;

    protected void setUp() throws Exception {
        this.appContext = ApplicationContextHelper.getApplicationContext();
        this.authenticationComponent = (AuthenticationComponent)this.appContext.getBean("authenticationComponent");
        this.transactionService = (TransactionService)this.appContext.getBean("transactionService");
        this.fileFolderService = (FileFolderService)this.appContext.getBean("fileFolderService");
        this.nodeService = (NodeService)this.appContext.getBean("nodeService");
        this.repository = (Repository)this.appContext.getBean("repositoryHelper");
        this.contentService = (ContentService)this.appContext.getBean("contentService");
        this.authenticationService = (MutableAuthenticationService)this.appContext.getBean("authenticationService");
        this.personService = (PersonService)this.appContext.getBean("personService");
        this.permissionService = (PermissionService)this.appContext.getBean("permissionService");
        this.siteService = (SiteService)this.appContext.getBean("siteService");
        this.authenticationComponent.setCurrentUser("admin");
        UserTransaction userTransaction = this.transactionService.getUserTransaction();
        userTransaction.begin();
        this.companyHome = this.repository.getCompanyHome();
        this.site = this.siteService.getSite(this.testSiteName);
        if (this.site != null) {
            this.siteService.deleteSite(this.testSiteName);
        }
        this.site = this.siteService.createSite(this.testSiteName, this.testSiteName, this.testSiteName, this.testSiteName, SiteVisibility.PUBLIC);
        WCMQuickStartTest.assertNotNull((Object)this.site);
        NodeRef docLib = this.nodeService.createNode(this.site.getNodeRef(), ContentModel.ASSOC_CONTAINS, QName.createQName((String)"documentLibrary"), ContentModel.TYPE_FOLDER).getChildRef();
        this.liveSite = this.nodeService.createNode(docLib, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"live"), WebSiteModel.TYPE_WEB_SITE).getChildRef();
        this.liveSiteRoot = this.nodeService.createNode(this.liveSite, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"root"), WebSiteModel.TYPE_WEB_ROOT).getChildRef();
        this.editorialSite = this.nodeService.createNode(docLib, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"editorial"), WebSiteModel.TYPE_WEB_SITE).getChildRef();
        this.editorialSiteRoot = this.nodeService.createNode(this.editorialSite, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"root"), WebSiteModel.TYPE_WEB_ROOT).getChildRef();
        userTransaction.commit();
    }

    protected void tearDown() throws Exception {
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        UserTransaction userTransaction = this.transactionService.getUserTransaction();
        userTransaction.begin();
        this.siteService.deleteSite(this.testSiteName);
        this.site = null;
        userTransaction.commit();
    }
}

