/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_wcmquickstart.model;

import java.util.List;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_wcmquickstart.model.WebSiteModel;
import org.alfresco.repo.node.NodeServicePolicies;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.RegexQNamePattern;

public class ImageType
implements WebSiteModel,
NodeServicePolicies.BeforeDeleteNodePolicy {
    private PolicyComponent policyComponent;
    private NodeService nodeService;

    public void setPolicyComponent(PolicyComponent policyComponent) {
        this.policyComponent = policyComponent;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void init() {
        this.policyComponent.bindClassBehaviour(NodeServicePolicies.BeforeDeleteNodePolicy.QNAME, TYPE_IMAGE, (Behaviour)new JavaBehaviour((Object)this, "beforeDeleteNode", Behaviour.NotificationFrequency.FIRST_EVENT));
    }

    public void beforeDeleteNode(NodeRef nodeRef) {
        if (!this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_PENDING_DELETE)) {
            this.removeAll(this.nodeService.getSourceAssocs(nodeRef, RegexQNamePattern.MATCH_ALL));
            this.removeAll(this.nodeService.getTargetAssocs(nodeRef, RegexQNamePattern.MATCH_ALL));
        }
    }

    private void removeAll(List<AssociationRef> assocs) {
        for (AssociationRef assoc : assocs) {
            this.nodeService.removeAssociation(assoc.getSourceRef(), assoc.getTargetRef(), assoc.getTypeQName());
        }
    }
}

