/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_wcmquickstart.benchmark;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.alfresco.repo.exporter.ACPExportPackageHandler;
import org.alfresco.service.cmr.repository.MimetypeService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.view.ExportPackageHandler;
import org.alfresco.service.cmr.view.ExporterCrawlerParameters;
import org.alfresco.service.cmr.view.ExporterService;
import org.alfresco.service.cmr.view.Location;

public class AcpGenerator {
    private static final String ACP_EXT = ".acp";
    private ExporterService exporterService;
    private NodeService nodeService;
    private MimetypeService mimetypeService;

    public File generateACP(NodeRef root, String destination) throws Exception {
        ExporterCrawlerParameters params = new ExporterCrawlerParameters();
        params.setCrawlSelf(true);
        params.setCrawlChildNodes(true);
        params.setExportFrom(new Location(root));
        File outputFile = this.getOutputFile(destination);
        int lastDotIndex = destination.lastIndexOf(46);
        if (lastDotIndex != -1) {
            destination = destination.substring(0, lastDotIndex);
        }
        File dataFile = new File(destination + "Data.xml");
        File contentDir = new File(destination + File.separator + "Content");
        FileOutputStream outputStream = new FileOutputStream(outputFile);
        ACPExportPackageHandler acpHandler = new ACPExportPackageHandler((OutputStream)outputStream, dataFile, contentDir, this.mimetypeService);
        acpHandler.setNodeService(this.nodeService);
        acpHandler.setExportAsFolders(false);
        this.exporterService.exportView((ExportPackageHandler)acpHandler, params, null);
        return outputFile;
    }

    private File getOutputFile(String destination) throws IOException {
        File outputFile;
        if (!((String)destination).endsWith(ACP_EXT)) {
            destination = (String)destination + ACP_EXT;
        }
        if (!(outputFile = new File((String)destination)).exists()) {
            outputFile.createNewFile();
        }
        return outputFile;
    }

    public void setExporterService(ExporterService exporterService) {
        this.exporterService = exporterService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setMimetypeService(MimetypeService mimetypeService) {
        this.mimetypeService = mimetypeService;
    }
}

