/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_wcmquickstart.benchmark;

import java.io.File;
import java.util.Random;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_wcmquickstart.benchmark.AcpGenerator;
import org.alfresco.module.org_alfresco_module_wcmquickstart.benchmark.TextGenerator;
import org.alfresco.module.org_alfresco_module_wcmquickstart.benchmark.Tree;
import org.alfresco.module.org_alfresco_module_wcmquickstart.benchmark.WebSiteBuilder;
import org.alfresco.module.org_alfresco_module_wcmquickstart.benchmark.WebSiteGenerator;
import org.alfresco.repo.nodelocator.NodeLocatorService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.site.SiteInfo;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.service.cmr.site.SiteVisibility;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.ParameterCheck;
import org.springframework.beans.factory.InitializingBean;

public class WebSiteRandomGenerator
implements WebSiteGenerator,
InitializingBean {
    public static final String WEB_SITE_HOME_NAME = "Alfresco Quick Start";
    private final Random random = new Random();
    private TextGenerator textGenerator;
    private WebSiteBuilder siteBuilder;
    private AcpGenerator acpGenerator;
    private NodeLocatorService nodeLocatorService;
    private SiteService siteService;
    private NodeService nodeService;
    private String shareSiteName = null;
    private int minSectionCount = 0;
    private int maxSectionCount = 8;
    private int minSectionDepth = 0;
    private int maxSectionDepth = 4;
    private NodeRef webHome;

    public File generateWebSiteAcp(String location) throws Exception {
        return this.acpGenerator.generateACP(this.webHome, location);
    }

    @Override
    public NodeRef generateWebSite(String siteName) {
        if (this.webHome == null) {
            this.webHome = this.findOrCreateWebHome();
        }
        Tree<String> siteStructure = this.generateRandomSiteStructure();
        return this.siteBuilder.buildSiteStructure(this.webHome, siteName, siteStructure);
    }

    private Tree<String> generateRandomSiteStructure() {
        String rootName = this.textGenerator.generateName();
        Tree<String> siteStructure = new Tree<String>(rootName);
        int childCount = this.getRandom(this.minSectionCount, this.maxSectionCount);
        for (int i = 0; i < childCount; ++i) {
            int sectionDepth = this.getRandom(this.minSectionDepth, this.maxSectionDepth);
            this.generateRandomSectionStructure(rootName, sectionDepth, siteStructure);
        }
        return siteStructure;
    }

    private void generateRandomSectionStructure(String parent, int maxDepth, Tree<String> siteStructure) {
        String child = this.textGenerator.generateName();
        siteStructure.appendChild(parent, child);
        if (maxDepth > 0) {
            int childCount = this.getRandom(this.minSectionCount, this.maxSectionCount);
            for (int i = 0; i < childCount; ++i) {
                this.generateRandomSectionStructure(child, maxDepth - 1, siteStructure);
            }
        }
    }

    private int getRandom(int min, int max) {
        double rand = this.random.nextGaussian();
        double range = (double)min - (double)max;
        return (int)Math.round(rand * range) + min;
    }

    public void afterPropertiesSet() throws Exception {
        ParameterCheck.mandatory((String)"nodeLocatorService", (Object)this.nodeLocatorService);
        ParameterCheck.mandatory((String)"siteService", (Object)this.siteService);
    }

    private NodeRef findOrCreateWebHome() {
        NodeRef webParent = this.findOrCreateWebParent();
        NodeRef webHomeNode = this.nodeService.getChildByName(webParent, ContentModel.ASSOC_CONTAINS, WEB_SITE_HOME_NAME);
        if (webHomeNode == null) {
            String localName = QName.createValidLocalName((String)WEB_SITE_HOME_NAME);
            QName assocName = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)localName);
            webHomeNode = this.nodeService.createNode(webParent, ContentModel.ASSOC_CONTAINS, assocName, ContentModel.TYPE_FOLDER).getChildRef();
        }
        return webHomeNode;
    }

    private NodeRef findOrCreateWebParent() {
        if (this.shareSiteName != null && !this.shareSiteName.isEmpty()) {
            return this.getOrCreateSiteDocumentLibrary();
        }
        return this.getCompanyHome();
    }

    private NodeRef getCompanyHome() {
        return this.nodeLocatorService.getNode("companyhome", null, null);
    }

    private NodeRef getOrCreateSiteDocumentLibrary() {
        NodeRef docLibrary;
        SiteInfo siteInfo = this.siteService.getSite(this.shareSiteName);
        if (siteInfo == null) {
            siteInfo = this.siteService.createSite("sitePreset", this.shareSiteName, this.shareSiteName, "", SiteVisibility.PUBLIC);
        }
        if ((docLibrary = this.siteService.getContainer(siteInfo.getShortName(), "documentLibrary")) == null) {
            docLibrary = this.siteService.createContainer(siteInfo.getShortName(), "documentLibrary", ContentModel.TYPE_FOLDER, null);
        }
        return docLibrary;
    }

    public void setWebSiteBuilder(WebSiteBuilder siteBuilder) {
        this.siteBuilder = siteBuilder;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setNodeLocatorService(NodeLocatorService nodeLocatorService) {
        this.nodeLocatorService = nodeLocatorService;
    }

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }

    public void setTextGenerator(TextGenerator textGenerator) {
        this.textGenerator = textGenerator;
    }

    public void setShareSiteName(String shareSiteName) {
        this.shareSiteName = shareSiteName;
    }

    public void setMinSectionCount(int minSectionCount) {
        this.minSectionCount = minSectionCount;
    }

    public void setMaxSectionCount(int maxSectionCount) {
        this.maxSectionCount = maxSectionCount;
    }

    public void setMinSectionDepth(int minSectionDepth) {
        this.minSectionDepth = minSectionDepth;
    }

    public void setMaxSectionDepth(int maxSectionDepth) {
        this.maxSectionDepth = maxSectionDepth;
    }
}

