/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_wcmquickstart.publish;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_wcmquickstart.model.WebSiteModel;
import org.alfresco.module.org_alfresco_module_wcmquickstart.publish.NodeRefMapper;
import org.alfresco.module.org_alfresco_module_wcmquickstart.publish.TransferPathMapper;
import org.alfresco.repo.transfer.TransferContext;
import org.alfresco.repo.transfer.manifest.TransferManifestDeletedNode;
import org.alfresco.repo.transfer.manifest.TransferManifestNode;
import org.alfresco.repo.transfer.manifest.TransferManifestNodeFactory;
import org.alfresco.repo.transfer.manifest.TransferManifestNormalNode;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.Path;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.transfer.TransferDefinition;
import org.alfresco.service.descriptor.Descriptor;
import org.alfresco.service.descriptor.DescriptorService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WebPublishingManifestNodeFactory
implements TransferManifestNodeFactory,
TransferPathMapper {
    private static final Log log = LogFactory.getLog(WebPublishingManifestNodeFactory.class);
    private List<Pair<Path, Path>> pathMap = new ArrayList<Pair<Path, Path>>();
    private TransferManifestNodeFactory realFactory;
    private NodeService nodeService;
    private DescriptorService descriptorService;
    private NodeRefMapper nodeRefMapper;

    public void setDelegate(TransferManifestNodeFactory realFactory) {
        this.realFactory = realFactory;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setDescriptorService(DescriptorService descriptorService) {
        this.descriptorService = descriptorService;
    }

    public void setNodeRefMapper(NodeRefMapper nodeRefMapper) {
        this.nodeRefMapper = nodeRefMapper;
    }

    public TransferManifestNode createTransferManifestNode(NodeRef nodeRef, TransferDefinition definition, TransferContext transferContext) {
        return this.createTransferManifestNode(nodeRef, definition, transferContext, false);
    }

    public TransferManifestNode createTransferManifestNode(NodeRef nodeRef, TransferDefinition definition, TransferContext transferContext, boolean forceDelete) {
        Date now = new Date();
        TransferManifestNode newNode = this.preProcess(nodeRef);
        if (newNode == null) {
            newNode = this.realFactory.createTransferManifestNode(nodeRef, definition, transferContext, forceDelete);
        }
        long start = 0L;
        if (log.isDebugEnabled()) {
            start = System.currentTimeMillis();
        }
        NodeRef origNodeRef = newNode.getNodeRef();
        NodeRef mappedNodeRef = this.getMappedNodeRef(origNodeRef);
        newNode.setNodeRef(mappedNodeRef);
        newNode.setUuid(mappedNodeRef.getId());
        ChildAssociationRef primaryParentAssoc = newNode.getPrimaryParentAssoc();
        NodeRef mappedParentNodeRef = this.getMappedNodeRef(primaryParentAssoc.getParentRef());
        Path parentPath = newNode.getParentPath();
        newNode.setParentPath(this.getMappedPath(parentPath));
        newNode.setPrimaryParentAssoc(new ChildAssociationRef(primaryParentAssoc.getTypeQName(), mappedParentNodeRef, primaryParentAssoc.getQName(), mappedNodeRef, primaryParentAssoc.isPrimary(), primaryParentAssoc.getNthSibling()));
        if (newNode instanceof TransferManifestNormalNode) {
            TransferManifestNormalNode normalNode = (TransferManifestNormalNode)newNode;
            ArrayList<ChildAssociationRef> mappedParentAssocs = new ArrayList<ChildAssociationRef>();
            List assocs = normalNode.getParentAssocs();
            for (Object assoc : assocs) {
                ChildAssociationRef childAssociationRef = new ChildAssociationRef(assoc.getTypeQName(), this.getMappedNodeRef(assoc.getParentRef()), assoc.getQName(), mappedNodeRef, assoc.isPrimary(), assoc.getNthSibling());
                mappedParentAssocs.add(childAssociationRef);
            }
            normalNode.setParentAssocs(mappedParentAssocs);
            Map props = normalNode.getProperties();
            if (props.containsKey(ContentModel.PROP_NODE_UUID)) {
                props.put(ContentModel.PROP_NODE_UUID, mappedNodeRef.getId());
            }
            if (props.containsKey(WebSiteModel.PROP_PUBLISHED_TIME)) {
                props.put(WebSiteModel.PROP_PUBLISHED_TIME, now);
            }
            for (Map.Entry entry : props.entrySet()) {
                Serializable value = (Serializable)entry.getValue();
                if (value instanceof List) {
                    List collection = (List)((Object)value);
                    if (collection.isEmpty() || !(collection.get(0) instanceof NodeRef)) continue;
                    ArrayList<NodeRef> newList = new ArrayList<NodeRef>(collection.size());
                    for (Serializable thisValue : collection) {
                        newList.add(this.getMappedNodeRef((NodeRef)thisValue));
                    }
                    props.put((QName)entry.getKey(), newList);
                    continue;
                }
                if (!(value instanceof NodeRef)) continue;
                props.put((QName)entry.getKey(), this.getMappedNodeRef((NodeRef)value));
            }
            List sourceAssocs = normalNode.getSourceAssocs();
            ArrayList<AssociationRef> arrayList = new ArrayList<AssociationRef>(sourceAssocs.size());
            for (AssociationRef sourceAssoc : sourceAssocs) {
                arrayList.add(new AssociationRef(sourceAssoc.getId(), this.getMappedNodeRef(sourceAssoc.getSourceRef()), sourceAssoc.getTypeQName(), mappedNodeRef));
            }
            normalNode.setSourceAssocs(arrayList);
            List targetAssocs = normalNode.getTargetAssocs();
            ArrayList<AssociationRef> newTargetAssocs = new ArrayList<AssociationRef>(targetAssocs.size());
            for (AssociationRef targetAssoc : targetAssocs) {
                newTargetAssocs.add(new AssociationRef(targetAssoc.getId(), mappedNodeRef, targetAssoc.getTypeQName(), this.getMappedNodeRef(targetAssoc.getTargetRef())));
            }
            normalNode.setTargetAssocs(newTargetAssocs);
        } else if (newNode instanceof TransferManifestDeletedNode) {
            this.processDeletedNode((TransferManifestDeletedNode)newNode);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Time taken to adjust manifest node: " + (System.currentTimeMillis() - start) + "ms"));
        }
        return newNode;
    }

    protected TransferManifestNode preProcess(NodeRef nodeRef) {
        NodeRef.Status status;
        TransferManifestDeletedNode result = null;
        Descriptor descriptor = this.descriptorService.getServerDescriptor();
        if ("3".equals(descriptor.getVersionMajor()) && "3".equals(descriptor.getVersionMinor()) && "4".compareTo(descriptor.getVersionRevision()) > 0 && (status = this.nodeService.getNodeStatus(nodeRef)).isDeleted()) {
            TransferManifestDeletedNode deletedNode = new TransferManifestDeletedNode();
            deletedNode.setNodeRef(new NodeRef(StoreRef.STORE_REF_ARCHIVE_SPACESSTORE, nodeRef.getId()));
            ChildAssociationRef dummyPrimaryParent = new ChildAssociationRef(ContentModel.ASSOC_CONTAINS, nodeRef, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"dummy"), nodeRef, true, -1);
            deletedNode.setPrimaryParentAssoc(dummyPrimaryParent);
            deletedNode.setParentPath(new Path());
            result = deletedNode;
        }
        return result;
    }

    protected void processDeletedNode(TransferManifestDeletedNode newNode) {
    }

    public NodeRef getMappedNodeRef(NodeRef node) {
        return this.nodeRefMapper.mapSourceNodeRef(node);
    }

    public Path getMappedPath(Path pathToConvert) {
        Path convertedPath = null;
        ArrayList<Pair<Path, Path>> possibleMatches = new ArrayList<Pair<Path, Path>>(this.pathMap);
        int pathSize = pathToConvert.size();
        for (int pathIndex = 0; pathIndex < pathSize && convertedPath == null && !possibleMatches.isEmpty(); ++pathIndex) {
            Path.Element currentElement = pathToConvert.get(pathIndex);
            String currentElementString = currentElement.getElementString();
            int pairIndex = 0;
            while (pairIndex < possibleMatches.size()) {
                Pair currentMapping = (Pair)possibleMatches.get(pairIndex);
                Path from = (Path)currentMapping.getFirst();
                if (pathIndex >= from.size() || !currentElementString.equals(from.get(pathIndex).getElementString())) {
                    possibleMatches.remove(pairIndex);
                    continue;
                }
                if (pathIndex == from.size() - 1) {
                    Path to = (Path)currentMapping.getSecond();
                    convertedPath = new Path();
                    convertedPath.append(to);
                    while (++pathIndex < pathSize) {
                        convertedPath.append(pathToConvert.get(pathIndex));
                    }
                    continue;
                }
                ++pairIndex;
            }
        }
        if (convertedPath == null) {
            convertedPath = pathToConvert;
        }
        return convertedPath;
    }

    public void setPathMap(List<Pair<Path, Path>> pathMap) {
        this.pathMap = new ArrayList<Pair<Path, Path>>(pathMap);
    }

    @Override
    public void addPathMapping(Path source, Path target) {
        this.addPathMapping((Pair<Path, Path>)new Pair((Object)source, (Object)target));
    }

    @Override
    public void addPathMapping(Pair<Path, Path> mapping) {
        boolean found = false;
        Path source = (Path)mapping.getFirst();
        for (int index = 0; index < this.pathMap.size(); ++index) {
            Pair<Path, Path> pair = this.pathMap.get(index);
            if (!((Path)pair.getFirst()).equals((Object)source)) continue;
            pair.setSecond((Object)((Path)mapping.getSecond()));
            found = true;
            break;
        }
        if (!found) {
            this.pathMap.add(mapping);
        }
    }
}

