/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_wcmquickstart.process;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_wcmquickstart.publish.PublishService;
import org.alfresco.repo.action.executer.ActionExecuterAbstractBase;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ParameterDefinition;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WebPublishAction
extends ActionExecuterAbstractBase {
    private static final Log log = LogFactory.getLog(WebPublishAction.class);
    private static final QName TYPE_BPM_PACKAGE = QName.createQName((String)"http://www.alfresco.org/model/bpm/1.0", (String)"package");
    private static final QName ASSOC_BPM_PACKAGE_CONTAINS = QName.createQName((String)"http://www.alfresco.org/model/bpm/1.0", (String)"packageContains");
    private static final QName ASPECT_BPM_WORKFLOW_PACKAGE = QName.createQName((String)"http://www.alfresco.org/model/bpm/1.0", (String)"workflowPackage");
    private NodeService nodeService;
    private PublishService publishService;

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setPublishService(PublishService publishService) {
        this.publishService = publishService;
    }

    protected void executeImpl(Action action, NodeRef actionedUponNodeRef) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("executeImpl on node " + String.valueOf(actionedUponNodeRef)));
        }
        HashSet<NodeRef> nodesToPublish = new HashSet<NodeRef>();
        if (this.nodeService.hasAspect(actionedUponNodeRef, ASPECT_BPM_WORKFLOW_PACKAGE)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Supplied node is a workflow package: " + String.valueOf(actionedUponNodeRef)));
            }
            ArrayList childAssocs = new ArrayList();
            childAssocs.addAll(this.nodeService.getChildAssocs(actionedUponNodeRef, (QNamePattern)ContentModel.ASSOC_CONTAINS, RegexQNamePattern.MATCH_ALL));
            if (TYPE_BPM_PACKAGE.equals((Object)this.nodeService.getType(actionedUponNodeRef))) {
                childAssocs.addAll(this.nodeService.getChildAssocs(actionedUponNodeRef, (QNamePattern)ASSOC_BPM_PACKAGE_CONTAINS, RegexQNamePattern.MATCH_ALL));
            }
            for (ChildAssociationRef childAssoc : childAssocs) {
                nodesToPublish.add(childAssoc.getChildRef());
            }
        } else {
            nodesToPublish.add(actionedUponNodeRef);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Queuing up nodes for publishing: " + String.valueOf(nodesToPublish)));
        }
        this.publishService.enqueuePublishedNodes(nodesToPublish);
    }

    protected void addParameterDefinitions(List<ParameterDefinition> paramList) {
    }
}

