/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_wcmquickstart.model;

import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.module.org_alfresco_module_wcmquickstart.model.WebSiteModel;
import org.alfresco.repo.node.NodeServicePolicies;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.BehaviourFilter;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VisitorFeedbackType
implements WebSiteModel {
    private static final Log log = LogFactory.getLog(VisitorFeedbackType.class);
    private static final String AFFECTED_VISITOR_FEEDBACK = "AffectedVisitorFeedback";
    public static final String COMMENT_TYPE = "Comment";
    public static final String CONTACT_REQUEST_TYPE = "Contact Request";
    private PolicyComponent policyComponent;
    private BehaviourFilter behaviourFilter;
    private NodeService nodeService;

    public void setPolicyComponent(PolicyComponent policyComponent) {
        this.policyComponent = policyComponent;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setBehaviourFilter(BehaviourFilter behaviourFilter) {
        this.behaviourFilter = behaviourFilter;
    }

    public void init() {
        this.policyComponent.bindClassBehaviour(NodeServicePolicies.OnUpdatePropertiesPolicy.QNAME, WebSiteModel.TYPE_VISITOR_FEEDBACK, (Behaviour)new JavaBehaviour((Object)this, "onUpdatePropertiesEveryEvent", Behaviour.NotificationFrequency.EVERY_EVENT));
        this.policyComponent.bindClassBehaviour(NodeServicePolicies.OnCreateNodePolicy.QNAME, WebSiteModel.TYPE_VISITOR_FEEDBACK, (Behaviour)new JavaBehaviour((Object)this, "onCreateNodeEveryEvent", Behaviour.NotificationFrequency.EVERY_EVENT));
        this.policyComponent.bindClassBehaviour(NodeServicePolicies.OnUpdatePropertiesPolicy.QNAME, WebSiteModel.TYPE_VISITOR_FEEDBACK, (Behaviour)new JavaBehaviour((Object)this, "onUpdatePropertiesOnCommit", Behaviour.NotificationFrequency.TRANSACTION_COMMIT));
        this.policyComponent.bindClassBehaviour(NodeServicePolicies.OnCreateNodePolicy.QNAME, WebSiteModel.TYPE_VISITOR_FEEDBACK, (Behaviour)new JavaBehaviour((Object)this, "onCreateNodeOnCommit", Behaviour.NotificationFrequency.TRANSACTION_COMMIT));
    }

    public void onCreateNodeEveryEvent(ChildAssociationRef childAssocRef) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("onCreateNode (every event) - recording node " + childAssocRef.getChildRef().toString()));
        }
        this.recordNode(childAssocRef.getChildRef());
    }

    public void onUpdatePropertiesEveryEvent(NodeRef nodeRef, Map<QName, Serializable> before, Map<QName, Serializable> after) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("onUpdateProperties (every event) - recording node " + nodeRef.toString()));
        }
        this.recordNode(nodeRef);
    }

    public void onCreateNodeOnCommit(ChildAssociationRef childAssocRef) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("onCreateNode (on commit) - process commit " + childAssocRef.getChildRef().toString()));
        }
        this.processCommit(childAssocRef.getChildRef());
    }

    public void onUpdatePropertiesOnCommit(NodeRef nodeRef, Map<QName, Serializable> before, Map<QName, Serializable> after) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("onUpdateProperties (on commit) - process commit " + nodeRef.toString()));
        }
        this.processCommit(nodeRef);
    }

    private void recordNode(NodeRef nodeRef) {
        HashSet<NodeRef> affectedNodeRefs = (HashSet<NodeRef>)AlfrescoTransactionSupport.getResource((Object)AFFECTED_VISITOR_FEEDBACK);
        if (affectedNodeRefs == null) {
            affectedNodeRefs = new HashSet<NodeRef>(5);
            AlfrescoTransactionSupport.bindResource((Object)AFFECTED_VISITOR_FEEDBACK, affectedNodeRefs);
        }
        affectedNodeRefs.add(nodeRef);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processCommit(NodeRef nodeRef) {
        Set affectedNodeRefs = (Set)AlfrescoTransactionSupport.getResource((Object)AFFECTED_VISITOR_FEEDBACK);
        if (affectedNodeRefs != null && affectedNodeRefs.remove(nodeRef)) {
            try {
                this.behaviourFilter.disableBehaviour(nodeRef, TYPE_VISITOR_FEEDBACK);
                Map props = this.nodeService.getProperties(nodeRef);
                NodeRef relevantArticle = (NodeRef)props.get(PROP_RELEVANT_ASSET);
                List assocs = this.nodeService.getTargetAssocs(nodeRef, (QNamePattern)ASSOC_RELEVANT_ASSET);
                boolean existingAssocRemoved = false;
                if (!assocs.isEmpty() && !((AssociationRef)assocs.get(0)).getTargetRef().equals((Object)relevantArticle)) {
                    this.nodeService.removeAssociation(nodeRef, relevantArticle, ASSOC_RELEVANT_ASSET);
                    existingAssocRemoved = true;
                }
                if (assocs.isEmpty() || existingAssocRemoved) {
                    this.nodeService.createAssociation(nodeRef, relevantArticle, ASSOC_RELEVANT_ASSET);
                }
                if (!props.containsKey(PROP_COMMENT_FLAGGED)) {
                    this.nodeService.setProperty(nodeRef, PROP_COMMENT_FLAGGED, (Serializable)Boolean.FALSE);
                }
                if (!props.containsKey(PROP_RATING_PROCESSED)) {
                    this.nodeService.setProperty(nodeRef, PROP_RATING_PROCESSED, (Serializable)Boolean.FALSE);
                }
            }
            finally {
                this.behaviourFilter.enableBehaviour(nodeRef, TYPE_VISITOR_FEEDBACK);
            }
        }
    }
}

